/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.craftful.block;

import agency.highlysuspect.packages.craftful.Packages;
import agency.highlysuspect.packages.craftful.PropsCommon;
import agency.highlysuspect.packages.craftful.block.PackageBlock;
import agency.highlysuspect.packages.craftful.content.PLatches;
import agency.highlysuspect.packages.craftful.junk.ImmutablePackageContents;
import agency.highlysuspect.packages.craftful.junk.PTags;
import agency.highlysuspect.packages.craftful.junk.PackageContainer2;
import agency.highlysuspect.packages.craftful.junk.PackageRules;
import agency.highlysuspect.packages.craftful.junk.PackageStyle;
import agency.highlysuspect.packages.craftful.net.PackageAction;
import agency.highlysuspect.quatlib.craftless.util.TwelveDirection;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_1268;
import net.minecraft.class_1275;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3829;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class PackageBlockEntity
extends class_2586
implements class_1275,
class_3829,
PackageRules,
PackageContainer2 {
    private PackageStyle style = PackageStyle.ERROR_LOL;
    private ImmutablePackageContents immutableContents = ImmutablePackageContents.EMPTY;
    private class_1799 stickyStack = class_1799.field_8037;
    private class_2561 customName;
    private boolean mapmakerLockedTag;
    private boolean syrupy;

    public PackageBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)PLatches.BlockEntityTypes.PACKAGE.get(), pos, state);
    }

    public PackageStyle getStyle() {
        return this.style;
    }

    public boolean canBeSticky() {
        if (this.syrupy) {
            return true;
        }
        if (this.field_11863 == null || ((Boolean)Packages.inst().config.get(PropsCommon.IN_WORLD_STICKY_PACKAGES)).booleanValue()) {
            return false;
        }
        for (class_2350 dir : class_2350.values()) {
            if (!this.field_11863.method_8320(this.method_11016().method_10093(dir)).method_26164(PTags.STICKY)) continue;
            return true;
        }
        return false;
    }

    public boolean isSticky() {
        return this.canBeSticky() && !this.stickyStack.method_7960();
    }

    public void updateStickyStack() {
        boolean anythingChanged = this.updateStickyStack0();
        if (anythingChanged) {
            this.method_5431();
        }
    }

    private boolean updateStickyStack0() {
        if (!this.canBeSticky()) {
            this.stickyStack = class_1799.field_8037;
            return true;
        }
        if (this.stickyStack.method_7960() && !this.immutableContents.isEmpty()) {
            this.stickyStack = this.immutableContents.stack().method_7972();
            return true;
        }
        return false;
    }

    public class_1799 getStickyStack() {
        return this.stickyStack;
    }

    public class_1799 getItemStackForDisplay() {
        if (this.immutableContents.isEmpty()) {
            return this.getStickyStack();
        }
        return this.immutableContents.stack().method_46651(this.immutableContents.count());
    }

    @Override
    public ImmutablePackageContents getContents() {
        return this.immutableContents;
    }

    @Override
    public void setContentsNonCommitted(ImmutablePackageContents newContents) {
        this.immutableContents = newContents;
    }

    @Override
    public void commitContents() {
        this.method_5431();
    }

    @Override
    public PackageRules getRules() {
        return this;
    }

    @Override
    public boolean allowedToInsertInPackage(class_1799 stack) {
        if (!this.stickyStack.method_7960() && !class_1799.method_31577((class_1799)this.stickyStack, (class_1799)stack)) {
            return false;
        }
        return PackageRules.super.allowedToInsertInPackage(stack);
    }

    public boolean performAction(class_1657 player, class_1268 hand, PackageAction action, boolean clientsideSimulate) {
        if (this.mapmakerLockedTag) {
            player.method_7353((class_2561)class_2561.method_43469((String)"container.isLocked", (Object[])new Object[]{this.method_5476()}), true);
            player.method_17356(class_3417.field_14731, class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        boolean didAnything = false;
        class_3414 soundToPlay = null;
        float volumeToPlay = 1.0f;
        float pitchToPlay = 1.0f;
        class_1799 held = player.method_5998(hand);
        if (player.method_5715() && held.method_31574((class_1792)PLatches.Items.STICKY_SYRUP.get())) {
            this.syrupy ^= true;
            if (this.syrupy) {
                soundToPlay = (class_3414)PLatches.SoundEvents.STICKY_SYRUP_APPLY.get();
                held.method_7970(1, (class_1309)player, hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
            } else {
                soundToPlay = (class_3414)PLatches.SoundEvents.STICKY_SYRUP_CLEAR.get();
                if (this.field_11863 != null) {
                    this.field_11863.method_8396(null, this.method_11016(), (class_3414)PLatches.SoundEvents.STICKY_SYRUP_CLEAR.get(), class_3419.field_15245, 1.0f, 1.0f);
                }
            }
            didAnything = true;
        } else if (action.isInsert()) {
            didAnything = this.playerInsert(player, hand, action, clientsideSimulate);
            if (didAnything) {
                soundToPlay = action.getSoundEvent();
                volumeToPlay = action.getSoundVolume();
                pitchToPlay = action.getSoundPitch(this.field_11863);
            }
        } else {
            didAnything = this.playerTakeDropLeftovers(player, hand, action, clientsideSimulate);
            if (didAnything) {
                soundToPlay = action.getSoundEvent();
                volumeToPlay = action.getSoundVolume();
                pitchToPlay = action.getSoundPitch(this.field_11863);
            } else if (!this.stickyStack.method_7960()) {
                this.stickyStack = class_1799.field_8037;
                didAnything = true;
                soundToPlay = (class_3414)PLatches.SoundEvents.STICKY_SYRUP_CLEAR.get();
            }
        }
        this.updateStickyStack0();
        if (!clientsideSimulate && didAnything) {
            this.method_5431();
        }
        if (this.field_11863 != null && soundToPlay != null && ((Boolean)Packages.inst().config.get(PropsCommon.INTERACTION_SOUNDS)).booleanValue() && !player.method_6059(class_1294.field_5905)) {
            this.field_11863.method_8396(player, this.method_11016(), soundToPlay, class_3419.field_15245, volumeToPlay, pitchToPlay);
        }
        return didAnything;
    }

    private boolean playerInsert(class_1657 player, class_1268 hand, PackageAction action, boolean simulate) {
        int x;
        if (!action.isInsert()) {
            throw new IllegalArgumentException("playerInsert only supports insertion actions, not " + String.valueOf((Object)action));
        }
        int handSlot = PackageBlockEntity.handToSlotId(player, hand);
        if (action == PackageAction.INSERT_ALL) {
            int favoriteSlot = player.method_5998(hand).method_7960() && this.immutableContents.isEmpty() ? this.slotWithALot(player).orElse(handSlot) : handSlot;
            boolean didAnything = false;
            IntIterator iterator = PackageBlockEntity.handSlotFirst(player, favoriteSlot).intIterator();
            while (iterator.hasNext()) {
                int inserted = this.insert0(player, iterator.nextInt(), Integer.MAX_VALUE, simulate);
                if (inserted == 0) continue;
                didAnything = true;
            }
            return didAnything;
        }
        int n = x = action == PackageAction.INSERT_ONE ? 1 : Integer.MAX_VALUE;
        if (this.stickyStack.method_7960() && this.immutableContents.isEmpty()) {
            return this.insert0(player, handSlot, x, simulate) > 0;
        }
        IntIterator iterator = PackageBlockEntity.handSlotFirst(player, handSlot).intIterator();
        while (iterator.hasNext()) {
            int inserted = this.insert0(player, iterator.nextInt(), x, simulate);
            if (inserted == 0) continue;
            return true;
        }
        return false;
    }

    private int insert0(class_1657 player, int slot, int maxAmountToInsert, boolean simulate) {
        class_1799 toInsert = player.method_31548().method_5438(slot);
        ImmutablePackageContents.InsertionResult result = this.immutableContents.withInsertion(toInsert, maxAmountToInsert, this.getRules());
        if (!simulate) {
            this.immutableContents = result.newContents();
            toInsert.method_7934(result.insertedAmount());
        }
        return result.insertedAmount();
    }

    private Optional<Integer> slotWithALot(class_1657 player) {
        HashMap<class_1792, MutableInt> runningTotal = new HashMap<class_1792, MutableInt>();
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 here = player.method_31548().method_5438(i);
            if (here.method_7960() || !this.getRules().allowedToInsertInPackage(here)) continue;
            runningTotal.computeIfAbsent(here.method_7909(), __ -> new MutableInt(0)).add(here.method_7947());
        }
        return runningTotal.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).flatMap(item -> {
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                if (player.method_31548().method_5438(i).method_7909() != item) continue;
                return Optional.of(i);
            }
            return Optional.empty();
        });
    }

    private PlayerTakeResult playerTake(class_1657 player, class_1268 hand, PackageAction action, boolean simulate) {
        int maxAmountToTake = switch (action) {
            case PackageAction.TAKE_ONE -> 1;
            case PackageAction.TAKE_STACK -> {
                int completionAmount;
                class_1799 held = player.method_5998(hand);
                if (!held.method_7960() && this.immutableContents.canStackWith(held) && (completionAmount = held.method_7914() - held.method_7947()) > 0) {
                    yield completionAmount;
                }
                yield this.getRules().maxPerPackageSlot(this.immutableContents.stack());
            }
            case PackageAction.TAKE_ALL -> Integer.MAX_VALUE;
            default -> throw new IllegalArgumentException("take() only supports taking actions, not " + String.valueOf((Object)action));
        };
        ImmutablePackageContents.TakeResult result = this.immutableContents.withTake(maxAmountToTake, this.getRules());
        if (result.takenAmount() == 0) {
            return new PlayerTakeResult(false, List.of());
        }
        class_1799 toGiveOverstack = this.immutableContents.stack().method_46651(result.takenAmount());
        if (simulate) {
            return new PlayerTakeResult(true, Collections.emptyList());
        }
        this.immutableContents = result.newContents();
        List<class_1799> toGive = PackageBlockEntity.flattenOverstack(toGiveOverstack);
        ArrayList<class_1799> leftovers = new ArrayList<class_1799>();
        for (class_1799 stack : toGive) {
            if (player.method_31548().method_7394(stack)) continue;
            leftovers.add(stack);
        }
        return new PlayerTakeResult(true, leftovers);
    }

    static List<class_1799> flattenOverstack(class_1799 mutOverstack) {
        ArrayList<class_1799> result = new ArrayList<class_1799>();
        while (!mutOverstack.method_7960()) {
            result.add(mutOverstack.method_7971(mutOverstack.method_7914()));
        }
        return result;
    }

    private boolean playerTakeDropLeftovers(class_1657 player, class_1268 hand, PackageAction action, boolean simulate) {
        PlayerTakeResult result = this.playerTake(player, hand, action, simulate);
        if (simulate || !result.successful() || result.leftovers().isEmpty() || this.field_11863 == null) {
            return result.successful();
        }
        class_243 spawnPos = class_243.method_24953((class_2382)this.method_11016()).method_1019(new class_243(((TwelveDirection)this.method_11010().method_11654(PackageBlock.FACING)).primaryDirection.method_23955()).method_1021(0.8));
        for (class_1799 stack : result.leftovers()) {
            class_1542 e = new class_1542(this.field_11863, spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, stack, 0.0, 0.01, 0.0);
            e.method_6982(10);
            this.field_11863.method_8649((class_1297)e);
        }
        return true;
    }

    private static int handToSlotId(class_1657 player, class_1268 hand) {
        return hand == class_1268.field_5808 ? player.method_31548().field_7545 : 40;
    }

    private static IntList handSlotFirst(class_1657 player, int handSlot) {
        int size = player.method_31548().method_5439();
        IntStream stream = handSlot == 0 ? IntStream.range(0, size) : (handSlot == size ? IntStream.concat(IntStream.of(handSlot), IntStream.range(0, size)) : IntStream.concat(IntStream.of(handSlot), IntStream.concat(IntStream.range(0, handSlot), IntStream.range(handSlot + 1, size))));
        return (IntList)stream.collect(IntArrayList::new, IntArrayList::add, IntList::addAll);
    }

    public void method_5431() {
        this.updateStickyStack0();
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public class_2561 method_5477() {
        return this.method_16914() ? this.customName : class_2561.method_43471((String)((PackageBlock)((Object)PLatches.Blocks.PACKAGE.get())).method_9539());
    }

    public class_2561 method_5797() {
        return this.customName;
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
    }

    public void method_5448() {
        this.immutableContents = ImmutablePackageContents.EMPTY;
    }

    public Object getRenderData() {
        return this.getStyle();
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 what) {
        super.method_11007(tag, what);
        this.style.save(tag);
        this.immutableContents.save(tag);
        if (this.customName != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName, (class_7225.class_7874)what));
        }
        tag.method_10566("StickyStack", this.stickyStack.method_57375(what));
        tag.method_10556("Syrupy", this.syrupy);
        if (this.mapmakerLockedTag) {
            tag.method_10556("bcLocked", true);
        }
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 what) {
        super.method_11014(tag, what);
        this.style = PackageStyle.load(tag);
        this.immutableContents = ImmutablePackageContents.load(tag);
        if (tag.method_10573("CustomName", 8)) {
            this.customName = PackageBlockEntity.method_59894((String)tag.method_10558("CustomName"), (class_7225.class_7874)what);
        }
        this.stickyStack = class_1799.method_57359((class_7225.class_7874)what, (class_2487)tag.method_10562("StickyStack"));
        this.syrupy = tag.method_10577("Syrupy");
        this.mapmakerLockedTag = tag.method_10545("bcLocked") && tag.method_10577("bcLocked");
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840(PackageStyle.DATA_COMPONENT_TYPE, (Object)this.style);
        builder.method_57840(ImmutablePackageContents.DATA_COMPONENT_TYPE, (Object)this.immutableContents);
        builder.method_57840(class_9334.field_49631, (Object)this.customName);
    }

    protected void method_57568(class_2586.class_9473 in) {
        super.method_57568(in);
        this.style = (PackageStyle)in.method_58695(PackageStyle.DATA_COMPONENT_TYPE, (Object)PackageStyle.ERROR_LOL);
        this.immutableContents = (ImmutablePackageContents)in.method_58695(ImmutablePackageContents.DATA_COMPONENT_TYPE, (Object)ImmutablePackageContents.EMPTY);
        this.customName = (class_2561)in.method_58694(class_9334.field_49631);
    }

    public void method_57569(class_2487 tag) {
        super.method_57569(tag);
        tag.method_10551("PackageStyle");
        tag.method_10551("PackageContents");
        tag.method_10551("CustomName");
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 what) {
        return this.method_58692(what);
    }

    public record PlayerTakeResult(boolean successful, List<class_1799> leftovers) {
    }
}

