/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.craftful.block;

import agency.highlysuspect.packages.craftful.Packages;
import agency.highlysuspect.packages.craftful.PropsCommon;
import agency.highlysuspect.packages.craftful.block.PackageMakerBlock;
import agency.highlysuspect.packages.craftful.content.PLatches;
import agency.highlysuspect.packages.craftful.item.PackageItem;
import agency.highlysuspect.packages.craftful.junk.PTags;
import agency.highlysuspect.packages.craftful.junk.PackageMakerStyle;
import agency.highlysuspect.packages.craftful.menu.PackageMakerMenu;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class PackageMakerBlockEntity
extends class_2586
implements class_1275,
class_1278,
class_3908 {
    public static final int FRAME_SLOT = 0;
    public static final int INNER_SLOT = 1;
    public static final int DYE_SLOT = 2;
    public static final int EXTRA_SLOT = 3;
    public static final int OUTPUT_SLOT = 4;
    public static final int SIZE = 5;
    private final class_2371<class_1799> inv = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
    private boolean locked;
    public static final int[] FRAME_AND_MISC = new int[]{0, 2, 3};
    public static final int[] INNER_AND_MISC = new int[]{1, 2, 3};
    public static final int[] OUTPUT = new int[]{4};
    private class_2561 customName;

    public PackageMakerBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)PLatches.BlockEntityTypes.PACKAGE_MAKER.get(), pos, state);
    }

    public static boolean matchesFrameSlot(class_1799 stack) {
        if (!PackageMakerBlockEntity.matchesFrameOrInnerSlotLogic(stack)) {
            return false;
        }
        return (Boolean)Packages.inst().config.get(PropsCommon.PACKAGE_MAKER_ALLOW_LIST_MODE) == false || stack.method_31573(PTags.ALLOWLIST_PACKAGE_MAKER_FRAME);
    }

    public static boolean matchesInnerSlot(class_1799 stack) {
        if (!PackageMakerBlockEntity.matchesFrameOrInnerSlotLogic(stack)) {
            return false;
        }
        return (Boolean)Packages.inst().config.get(PropsCommon.PACKAGE_MAKER_ALLOW_LIST_MODE) == false || stack.method_31573(PTags.ALLOWLIST_PACKAGE_MAKER_INNER);
    }

    private static boolean matchesFrameOrInnerSlotLogic(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_1792 item = stack.method_7909();
        if (!(item instanceof class_1747)) {
            return false;
        }
        if (stack.method_31573(PTags.BANNED_FROM_PACKAGE_MAKER)) {
            return false;
        }
        class_2248 b = ((class_1747)item).method_7711();
        class_2680 state = b.method_9564();
        return state.method_26225();
    }

    public static boolean matchesDyeSlot(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        if (stack.method_31573(PTags.BANNED_FROM_PACKAGE_MAKER)) {
            return false;
        }
        return stack.method_7909() instanceof class_1769;
    }

    public static boolean matchesExtraSlot(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        return stack.method_31573(PTags.THINGS_YOU_NEED_FOR_PACKAGE_CRAFTING);
    }

    public static class_1799 whatWouldBeCrafted(class_1263 container) {
        class_1799 frame = container.method_5438(0);
        class_1799 inner = container.method_5438(1);
        class_1799 dye = container.method_5438(2);
        class_1799 extra = container.method_5438(3);
        if (!PackageMakerBlockEntity.matchesFrameSlot(frame)) {
            return class_1799.field_8037;
        }
        if (!PackageMakerBlockEntity.matchesInnerSlot(inner)) {
            return class_1799.field_8037;
        }
        if (!PackageMakerBlockEntity.matchesDyeSlot(dye)) {
            return class_1799.field_8037;
        }
        if (!PackageMakerBlockEntity.matchesExtraSlot(extra)) {
            return class_1799.field_8037;
        }
        class_2248 frameBlock = ((class_1747)frame.method_7909()).method_7711();
        class_2248 innerBlock = ((class_1747)inner.method_7909()).method_7711();
        class_1767 dyeColor = ((class_1769)dye.method_7909()).method_7802();
        return ((PackageItem)((Object)PLatches.Items.PACKAGE.get())).createCustomizedStack(frameBlock, innerBlock, dyeColor);
    }

    public class_1799 whatWouldBeCrafted() {
        return PackageMakerBlockEntity.whatWouldBeCrafted((class_1263)this);
    }

    public void performCraft() {
        this.performCraft(1);
    }

    public void performCraft(int max) {
        boolean playedSound = false;
        for (int i = 0; i < max; ++i) {
            class_1799 wouldCraft = this.whatWouldBeCrafted();
            if (wouldCraft.method_7960()) {
                return;
            }
            class_1799 currentOutputStack = (class_1799)this.inv.get(4);
            if (currentOutputStack.method_7960()) {
                this.inv.set(4, (Object)wouldCraft);
            } else if (currentOutputStack.method_7947() != currentOutputStack.method_7914() && class_1799.method_31577((class_1799)currentOutputStack, (class_1799)wouldCraft)) {
                currentOutputStack.method_7933(1);
            } else {
                return;
            }
            ((class_1799)this.inv.get(0)).method_7934(1);
            ((class_1799)this.inv.get(1)).method_7934(1);
            ((class_1799)this.inv.get(2)).method_7934(1);
            ((class_1799)this.inv.get(3)).method_7934(1);
            this.method_5431();
            if (this.field_11863 == null || playedSound) continue;
            this.field_11863.method_8396(null, this.field_11867, (class_3414)PLatches.SoundEvents.PACKAGE_MAKER_CRAFT.get(), class_3419.field_15245, 1.0f, 1.0f);
            playedSound = true;
        }
    }

    public boolean hasFrame() {
        return !((class_1799)this.inv.get(0)).method_7960();
    }

    public boolean hasInner() {
        return !((class_1799)this.inv.get(1)).method_7960();
    }

    public boolean hasDye() {
        return !((class_1799)this.inv.get(2)).method_7960();
    }

    public boolean hasExtra() {
        return !((class_1799)this.inv.get(3)).method_7960();
    }

    public boolean hasOutput() {
        return !((class_1799)this.inv.get(4)).method_7960();
    }

    @Nullable
    public Object getRenderAttachmentData() {
        return this.getStyle();
    }

    public PackageMakerStyle getStyle() {
        class_1767 class_17672;
        class_1792 class_17922;
        class_2248 innerBlock;
        class_1792 class_17923;
        class_2248 frameBlock;
        class_1792 class_17924;
        class_1799 frameStack = (class_1799)this.inv.get(0);
        class_1799 innerStack = (class_1799)this.inv.get(1);
        class_1799 dyeStack = (class_1799)this.inv.get(2);
        if (!frameStack.method_7960() && (class_17924 = frameStack.method_7909()) instanceof class_1747) {
            class_1747 frameItem = (class_1747)class_17924;
            v0 = frameItem.method_7711();
        } else {
            v0 = frameBlock = null;
        }
        if (!innerStack.method_7960() && (class_17923 = innerStack.method_7909()) instanceof class_1747) {
            class_1747 innerItem = (class_1747)class_17923;
            v1 = innerItem.method_7711();
        } else {
            v1 = innerBlock = null;
        }
        if (!dyeStack.method_7960() && (class_17922 = dyeStack.method_7909()) instanceof class_1769) {
            class_1769 dyeItem = (class_1769)class_17922;
            class_17672 = dyeItem.method_7802();
        } else {
            class_17672 = null;
        }
        class_1767 dyeColor = class_17672;
        return new PackageMakerStyle(frameBlock, innerBlock, dyeColor);
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return OUTPUT;
        }
        if (side == class_2350.field_11036) {
            return FRAME_AND_MISC;
        }
        return INNER_AND_MISC;
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return this.method_5437(slot, stack);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 4;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return switch (slot) {
            case 0 -> PackageMakerBlockEntity.matchesFrameSlot(stack);
            case 1 -> PackageMakerBlockEntity.matchesInnerSlot(stack);
            case 2 -> PackageMakerBlockEntity.matchesDyeSlot(stack);
            case 3 -> PackageMakerBlockEntity.matchesExtraSlot(stack);
            default -> false;
        };
    }

    public int method_5439() {
        return 5;
    }

    public boolean method_5442() {
        for (class_1799 stack : this.inv) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inv.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inv, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inv, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inv.set(slot, (Object)stack);
    }

    public boolean method_5443(class_1657 player) {
        if (this.locked) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.inv.clear();
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        if (this.locked) {
            player.method_7353((class_2561)class_2561.method_43469((String)"container.isLocked", (Object[])new Object[]{this.method_5476()}), true);
            player.method_17356(class_3417.field_14731, class_3419.field_15245, 1.0f, 1.0f);
            return null;
        }
        return new PackageMakerMenu(syncId, inv, (class_1263)this);
    }

    public class_2561 method_5477() {
        return this.method_16914() ? this.customName : class_2561.method_43471((String)((PackageMakerBlock)((Object)PLatches.Blocks.PACKAGE_MAKER.get())).method_9539());
    }

    public boolean method_16914() {
        return this.customName != null;
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    public class_2561 method_5797() {
        return this.customName;
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 what) {
        if (this.method_16914()) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName, (class_7225.class_7874)what));
        }
        if (this.locked) {
            tag.method_10556("bcLocked", true);
        }
        class_1262.method_5426((class_2487)tag, this.inv, (class_7225.class_7874)what);
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 what) {
        this.customName = tag.method_10573("CustomName", 8) ? class_2561.class_2562.method_10877((String)tag.method_10558("CustomName"), (class_7225.class_7874)what) : null;
        this.inv.clear();
        class_1262.method_5429((class_2487)tag, this.inv, (class_7225.class_7874)what);
        boolean bl = this.locked = tag.method_10545("bcLocked") && tag.method_10577("bcLocked");
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            Packages.inst().proxy.forceChunkRerender(this.field_11863, this.method_11016());
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 what) {
        return this.method_38244(what);
    }
}

