/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.craftful.client;

import agency.highlysuspect.packages.craftful.block.PackageBlock;
import agency.highlysuspect.packages.craftful.block.PackageBlockEntity;
import agency.highlysuspect.packages.craftful.client.PackageActionBinding;
import agency.highlysuspect.packages.craftful.client.PackagesClient;
import agency.highlysuspect.packages.craftful.client.PropsClient;
import agency.highlysuspect.packages.craftful.net.ActionPacket;
import agency.highlysuspect.packages.craftful.net.PackageAction;
import agency.highlysuspect.quatlib.craftless.util.TwelveDirection;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class PClientBlockEventHandlers {
    private static class_2338 lastPunchPosLegacy;
    private static long lastPunchTickLegacy;
    private static final int NOPE = 10000;

    public static boolean onEarlyLeftClick(class_1657 player, class_1937 level, class_2338 pos, class_2350 direction) {
        if (!PClientBlockEventHandlers.canAttack(player, level, pos, direction)) {
            return false;
        }
        return PClientBlockEventHandlers.performPunchAction(player, level, pos, direction);
    }

    public static class_1269 onHoldLeftClick(class_1657 player, class_1937 level, class_1268 hand, class_2338 pos, class_2350 direction) {
        if (PClientBlockEventHandlers.canAttack(player, level, pos, direction)) {
            int punchRepeat = (Integer)PackagesClient.inst().config.get(PropsClient.PUNCH_REPEAT);
            if (!level.field_9236 || punchRepeat < 0) {
                return class_1269.field_21466;
            }
            if (pos.equals((Object)lastPunchPosLegacy) && level.method_8510() - lastPunchTickLegacy <= (long)punchRepeat) {
                return class_1269.field_21466;
            }
            lastPunchPosLegacy = pos;
            lastPunchTickLegacy = level.method_8510();
            PClientBlockEventHandlers.performPunchAction(player, level, pos, direction);
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public static class_1269 onRightClick(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (!level.field_9236 || player.method_7325()) {
            return class_1269.field_5811;
        }
        class_2338 pos = hitResult.method_17777();
        class_2680 state = level.method_8320(pos);
        class_2586 be = level.method_8321(pos);
        if (!(state.method_26204() instanceof PackageBlock) || !(be instanceof PackageBlockEntity)) {
            return class_1269.field_5811;
        }
        PackageBlockEntity pkg = (PackageBlockEntity)be;
        class_2350 direction = hitResult.method_17780();
        class_2350 frontDir = ((TwelveDirection)state.method_11654(PackageBlock.FACING)).primaryDirection;
        if (direction != frontDir) {
            return class_1269.field_5811;
        }
        PackageAction action = PClientBlockEventHandlers.getApplicableAction(player, PackageActionBinding.MainTrigger.USE);
        if (action == null) {
            return class_1269.field_5811;
        }
        if (pkg.performAction(player, hand, action, true)) {
            PackagesClient.inst().sendActionPacket(new ActionPacket(pos, hand, action));
            player.method_6104(hand);
            return class_1269.field_21466;
        }
        return player.method_5715() ? class_1269.field_5811 : class_1269.field_21466;
    }

    private static boolean canAttack(class_1657 player, class_1937 level, class_2338 pos, class_2350 direction) {
        if (player.method_7325()) {
            return false;
        }
        class_2680 state = level.method_8320(pos);
        if (!(state.method_26204() instanceof PackageBlock)) {
            return false;
        }
        class_2350 frontDir = ((TwelveDirection)state.method_11654(PackageBlock.FACING)).primaryDirection;
        if (direction != frontDir) {
            return false;
        }
        return !player.method_5998(class_1268.field_5808).method_7951(state);
    }

    private static boolean performPunchAction(class_1657 player, class_1937 level, class_2338 pos, class_2350 direction) {
        class_2680 state = level.method_8320(pos);
        class_2586 be = level.method_8321(pos);
        if (!(state.method_26204() instanceof PackageBlock) || !(be instanceof PackageBlockEntity)) {
            return false;
        }
        PackageBlockEntity pkg = (PackageBlockEntity)be;
        PackageAction action = PClientBlockEventHandlers.getApplicableAction(player, PackageActionBinding.MainTrigger.PUNCH);
        if (action == null) {
            return false;
        }
        if (pkg.performAction(player, class_1268.field_5808, action, true)) {
            PackagesClient.inst().sendActionPacket(new ActionPacket(pos, class_1268.field_5808, action));
            lastPunchTickLegacy = level.method_8510();
            return true;
        }
        return false;
    }

    @Nullable
    private static PackageAction getApplicableAction(class_1657 player, PackageActionBinding.MainTrigger main) {
        PackageActionBinding leastWrongBinding = null;
        int leastWrongness = 10000;
        for (PackageActionBinding binding : PackagesClient.inst().sortedBindings) {
            int wrongness = PClientBlockEventHandlers.computeWrongness(player, binding, main);
            if (wrongness == 0) {
                return binding.action();
            }
            if (wrongness >= leastWrongness) continue;
            leastWrongness = wrongness;
            leastWrongBinding = binding;
        }
        if (leastWrongBinding != null) {
            return leastWrongBinding.action();
        }
        return null;
    }

    private static int computeWrongness(class_1657 player, PackageActionBinding binding, PackageActionBinding.MainTrigger main) {
        if (binding.mainTrigger() == PackageActionBinding.MainTrigger.UNDEFINED || binding.mainTrigger() != main) {
            return 10000;
        }
        int wrongness = 0;
        if (binding.ctrl() != class_437.method_25441()) {
            if (binding.ctrl()) {
                return 10000;
            }
            ++wrongness;
        }
        if (binding.alt() != class_437.method_25443()) {
            if (binding.alt()) {
                return 10000;
            }
            ++wrongness;
        }
        if (binding.sneak() != player.method_5715()) {
            if (binding.sneak()) {
                return 10000;
            }
            ++wrongness;
        }
        return wrongness;
    }
}

