/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.craftful.client;

import agency.highlysuspect.packages.craftful.Packages;
import agency.highlysuspect.packages.craftful.net.PackageAction;
import java.util.ArrayList;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public record PackageActionBinding(PackageAction action, boolean ctrl, boolean sneak, boolean alt, MainTrigger mainTrigger) implements Comparable<PackageActionBinding>
{
    public int specificity() {
        int s = 0;
        if (this.ctrl) {
            ++s;
        }
        if (this.sneak) {
            ++s;
        }
        if (this.alt) {
            ++s;
        }
        return s;
    }

    @Override
    public int compareTo(@NotNull PackageActionBinding o) {
        return -Integer.compare(this.specificity(), o.specificity());
    }

    public String asString() {
        if (this.mainTrigger == MainTrigger.UNDEFINED) {
            return "";
        }
        ArrayList<String> parts = new ArrayList<String>();
        if (this.ctrl) {
            parts.add("ctrl");
        }
        if (this.sneak) {
            parts.add("sneak");
        }
        if (this.alt) {
            parts.add("alt");
        }
        if (this.mainTrigger == MainTrigger.PUNCH) {
            parts.add("punch");
        }
        if (this.mainTrigger == MainTrigger.USE) {
            parts.add("use");
        }
        return String.join((CharSequence)"-", parts);
    }

    public static PackageActionBinding fromString(PackageAction action, String s) {
        Builder b = new Builder(action);
        if (s.isEmpty()) {
            return b.build();
        }
        block19: for (String option : s.split("-")) {
            switch (option.toLowerCase(Locale.ROOT)) {
                case "ctrl": {
                    b.ctrl();
                    continue block19;
                }
                case "sneak": 
                case "shift": {
                    b.sneak();
                    continue block19;
                }
                case "alt": {
                    b.alt();
                    continue block19;
                }
                case "punch": 
                case "attack": 
                case "left": {
                    b.punch();
                    continue block19;
                }
                case "use": 
                case "right": 
                case "activate": {
                    b.use();
                    continue block19;
                }
                default: {
                    Packages.LOG.warn("Unknown PackageActionBinding component '" + option + "', skipping", new Object[0]);
                }
            }
        }
        return b.build();
    }

    public static enum MainTrigger {
        PUNCH,
        USE,
        UNDEFINED;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class Builder {
        public final PackageAction action;
        public boolean ctrl;
        public boolean sneak;
        public boolean alt;
        public MainTrigger mainTrigger = MainTrigger.UNDEFINED;

        public Builder(PackageAction action) {
            this.action = action;
        }

        public Builder ctrl() {
            this.ctrl = true;
            return this;
        }

        public Builder sneak() {
            this.sneak = true;
            return this;
        }

        public Builder alt() {
            this.alt = true;
            return this;
        }

        public Builder punch() {
            this.mainTrigger = MainTrigger.PUNCH;
            return this;
        }

        public Builder use() {
            this.mainTrigger = MainTrigger.USE;
            return this;
        }

        public PackageActionBinding build() {
            return new PackageActionBinding(this.action, this.ctrl, this.sneak, this.alt, this.mainTrigger);
        }
    }
}

