/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.craftful.client;

import agency.highlysuspect.packages.craftful.block.PackageBlock;
import agency.highlysuspect.packages.craftful.block.PackageBlockEntity;
import agency.highlysuspect.packages.craftful.client.PackagesClient;
import agency.highlysuspect.packages.craftful.client.PropsClient;
import agency.highlysuspect.packages.craftful.junk.ImmutablePackageContents;
import agency.highlysuspect.packages.craftful.junk.PackageRules;
import agency.highlysuspect.quatlib.craftless.client.MyBlockEntityRendererProvider;
import agency.highlysuspect.quatlib.craftless.util.TwelveDirection;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2477;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class PackageRenderer
implements class_827<PackageBlockEntity> {
    private final class_327 textRenderer;
    private static final Quaternionf YP_90 = class_7833.field_40716.rotationDegrees(90.0f);
    private static final Quaternionf[] MAGIC_QUATS = new Quaternionf[TwelveDirection.values().length];
    private static final int MAX_ITEM_RENDER_DEPTH = 5;
    private static final Matrix4f[] ITEM_TRANSFORMATIONS;
    private static int depth;

    public PackageRenderer(MyBlockEntityRendererProvider.MyContext context) {
        this.textRenderer = context.getFont();
    }

    public void render(PackageBlockEntity blockEntity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_239 class_2392;
        class_1297 player = class_310.method_1551().method_1560();
        if (blockEntity.method_10997() == null || player == null) {
            return;
        }
        class_1937 world = blockEntity.method_10997();
        class_2680 packageState = blockEntity.method_11010();
        if (!(packageState.method_26204() instanceof PackageBlock)) {
            return;
        }
        TwelveDirection packageTwelveDir = (TwelveDirection)packageState.method_11654(PackageBlock.FACING);
        switch ((Integer)PackagesClient.inst().config.get(PropsClient.LIGHTING_CORRECTION)) {
            case 2: {
                if (light != 0) break;
            }
            case 1: {
                light = class_761.method_23794((class_1920)world, (class_2338)blockEntity.method_11016().method_10093(packageTwelveDir.primaryDirection));
            }
        }
        matrices.method_22903();
        matrices.method_22904(0.5, 0.5, 0.5);
        PackageRenderer.applyRotation(matrices, packageTwelveDir);
        class_1799 stackToDisplay = blockEntity.getItemStackForDisplay();
        if (!stackToDisplay.method_7960()) {
            PackageRenderer.drawItem(matrices, vertexConsumers, stackToDisplay, light);
        }
        int detailLevel = player.method_5715() ? 1 : 0;
        double distanceSq = player.method_5836(1.0f).method_1025(class_243.method_24953((class_2382)blockEntity.method_11016()));
        if (distanceSq <= 64.0 && (class_2392 = player.method_5745(8.0, 0.0f, false)) instanceof class_3965) {
            class_3965 blockHit = (class_3965)class_2392;
            if (blockEntity.method_11016().equals((Object)blockHit.method_17777())) {
                ++detailLevel;
            }
        }
        boolean sticky = blockEntity.canBeSticky();
        if (detailLevel > 0) {
            ImmutablePackageContents contents = blockEntity.getContents();
            PackageRules rules = blockEntity.getRules();
            int count = contents.count();
            int maxPerSlot = rules.maxPerPackageSlot(stackToDisplay);
            boolean full = contents.isFull(rules);
            this.drawText(matrices, vertexConsumers, light, count, maxPerSlot, full, sticky, detailLevel, Math.sqrt(distanceSq));
        }
        matrices.method_22909();
    }

    public static void applyRotation(class_4587 ps, TwelveDirection dir) {
        ps.method_23760().method_23761().rotate((Quaternionfc)MAGIC_QUATS[dir.ordinal()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawItem(class_4587 ps, class_4597 bufs, class_1799 stack, int light) {
        ps.method_22903();
        Matrix4f transformation = ITEM_TRANSFORMATIONS[class_3532.method_15340((int)depth, (int)0, (int)4)];
        ps.method_23760().method_23761().mul((Matrix4fc)transformation);
        try {
            if (++depth < 5) {
                class_310.method_1551().method_1480().method_23178(stack, class_811.field_4317, light, class_4608.field_21444, ps, bufs, null, 0);
            }
        }
        finally {
            --depth;
            ps.method_22909();
        }
    }

    private void drawText(class_4587 matrices, class_4597 vertexConsumers, int light, int count, int maxPerSlot, boolean isFull, boolean sticky, int detailLevel, double distance) {
        Object text;
        if (detailLevel == 2) {
            if (maxPerSlot <= 1) {
                text = count + "x1";
            } else {
                int stacks = count / maxPerSlot;
                int leftover = count % maxPerSlot;
                text = stacks + "x" + maxPerSlot + " + " + leftover;
            }
        } else {
            text = String.valueOf(count);
        }
        int color = (isFull ? 0xFF6600 : 0xFFFFFF) | (distance - 0.5 >= class_310.method_1551().field_1724.method_55754() ? 0x55000000 : -16777216);
        int shadowColor = (color & 0xFCFCFC) >> 2;
        float scale = detailLevel == 2 && maxPerSlot == 1 ? 0.033333335f : (detailLevel == 2 ? 0.014285714f : (count < 10 ? 0.06666667f : (count < 100 ? 0.04347826f : 0.033333335f)));
        matrices.method_22903();
        matrices.method_22904(0.425, 0.0, 0.0);
        if (detailLevel == 2 && sticky) {
            String s = class_2477.method_10517().method_48307("packages.sticky");
            matrices.method_22903();
            matrices.method_22905(-1.0f, -0.01f, 0.01f);
            matrices.method_46416(0.0f, 25.0f, 0.0f);
            matrices.method_22907(YP_90);
            int c = 15847062;
            int cShadow = (c & 0xFCFCFC) >> 2;
            int minusHalfWidth = -this.textRenderer.method_1727(s) / 2;
            this.textRenderer.method_27521(s, (float)(minusHalfWidth + 1), 1.0f, cShadow, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0, light);
            matrices.method_22904(0.0, 0.0, -0.001);
            this.textRenderer.method_27521(s, (float)minusHalfWidth, 0.0f, c, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0, light);
            matrices.method_22909();
        }
        matrices.method_22905(-1.0f, -scale, scale);
        matrices.method_46416(0.0f, -4.0f, 0.0f);
        matrices.method_22907(YP_90);
        int minusHalfWidth = -this.textRenderer.method_1727((String)text) / 2;
        this.textRenderer.method_27521((String)text, (float)(minusHalfWidth + 1), 1.0f, shadowColor, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0, light);
        matrices.method_22904(0.0, 0.0, -0.001);
        this.textRenderer.method_27521((String)text, (float)minusHalfWidth, 0.0f, color, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0, light);
        matrices.method_22909();
    }

    static {
        for (TwelveDirection dir : TwelveDirection.values()) {
            if (dir.secondaryDirection != null) {
                Quaternionf magic1 = class_7833.field_40716.rotationDegrees(-dir.secondaryDirection.method_10144() + 90.0f);
                Quaternionf magic2 = class_7833.field_40718.rotationDegrees(dir.primaryDirection == class_2350.field_11036 ? 90.0f : -90.0f);
                PackageRenderer.MAGIC_QUATS[dir.ordinal()] = magic1.mul((Quaternionfc)magic2);
                continue;
            }
            PackageRenderer.MAGIC_QUATS[dir.ordinal()] = class_7833.field_40716.rotationDegrees(-dir.primaryDirection.method_10144() - 90.0f);
        }
        ITEM_TRANSFORMATIONS = new Matrix4f[5];
        for (int depth = 0; depth < ITEM_TRANSFORMATIONS.length; ++depth) {
            Matrix4f pose = new Matrix4f();
            if (depth == 0) {
                pose.translate(0.381f, 0.0f, 0.0f);
                pose.rotate((Quaternionfc)YP_90);
                pose.scale(0.75f, 0.75f, 0.005f);
            } else {
                pose.translate(0.445f, 0.0f, 0.0f);
                pose.rotate((Quaternionfc)YP_90);
                pose.scale(0.75f, 0.75f, (float)depth * 0.06f);
            }
            PackageRenderer.ITEM_TRANSFORMATIONS[depth] = pose;
        }
        depth = 0;
    }
}

