/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.craftful.fab;

import agency.highlysuspect.packages.craftful.junk.ImmutablePackageContents;
import agency.highlysuspect.packages.craftful.junk.PackageContainer2;
import agency.highlysuspect.quatlib.craftless.util.QuatUtil;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;

public class PackageStorage
extends SnapshotParticipant<ImmutablePackageContents>
implements SingleSlotStorage<ItemVariant> {
    public final PackageContainer2 container;

    public PackageStorage(PackageContainer2 container) {
        this.container = container;
    }

    protected ImmutablePackageContents createSnapshot() {
        return this.container.getContents();
    }

    protected void readSnapshot(ImmutablePackageContents snapshot) {
        this.container.setContentsNonCommitted(snapshot);
    }

    protected void onFinalCommit() {
        this.container.commitContents();
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        int maxAmountSmall = (int)QuatUtil.clampL((long)maxAmount, (long)0L, (long)Integer.MAX_VALUE);
        class_1799 stackToInsert = resource.toStack(maxAmountSmall);
        ImmutablePackageContents.InsertionResult result = this.container.getContents().withInsertion(stackToInsert, maxAmountSmall, this.container.getRules());
        if (result.insertedAmount() > 0) {
            this.updateSnapshots(transaction);
            this.container.setContentsNonCommitted(result.newContents());
        }
        return result.insertedAmount();
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        int maxAmountSmall = (int)QuatUtil.clampL((long)maxAmount, (long)0L, (long)Integer.MAX_VALUE);
        class_1799 stackToExtract = resource.toStack(maxAmountSmall);
        ImmutablePackageContents.TakeResult result = this.container.getContents().withFilteredTake(stackToExtract, maxAmountSmall, this.container.getRules());
        if (result.takenAmount() > 0) {
            this.updateSnapshots(transaction);
            this.container.setContentsNonCommitted(result.newContents());
        }
        return result.takenAmount();
    }

    public boolean isResourceBlank() {
        return this.container.getContents().isEmpty();
    }

    public ItemVariant getResource() {
        ImmutablePackageContents contents = this.container.getContents();
        return contents.isEmpty() ? ItemVariant.blank() : ItemVariant.of((class_1799)contents.stack());
    }

    public long getAmount() {
        return this.container.getContents().count();
    }

    public long getCapacity() {
        ImmutablePackageContents contents = this.container.getContents();
        return contents.isEmpty() ? 512L : (long)this.container.getRules().maxInPackageTotal(contents.stack());
    }
}

