/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.craftful.junk;

import agency.highlysuspect.packages.craftful.junk.PackageRules;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public record ImmutablePackageContents(class_1799 stack, int count) {
    public static ImmutablePackageContents EMPTY = new ImmutablePackageContents(class_1799.field_8037, 0);
    public static final Codec<ImmutablePackageContents> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_1799.field_24671.optionalFieldOf("stack").forGetter(ImmutablePackageContents::stackForSerialization), (App)Codec.INT.fieldOf("count").forGetter(ImmutablePackageContents::count)).apply((Applicative)i, ImmutablePackageContents::rehydrate));
    public static final class_9139<class_9129, ImmutablePackageContents> STREAM_CODEC = new class_9139<class_9129, ImmutablePackageContents>(){

        public void encode(class_9129 buf, ImmutablePackageContents cont) {
            Optional<class_1799> filt = cont.stackForSerialization();
            if (filt.isEmpty()) {
                buf.method_53002(0);
            } else {
                buf.method_53002(cont.count());
                class_1799.field_48349.encode((Object)buf, (Object)filt.get());
            }
        }

        public ImmutablePackageContents decode(class_9129 buf) {
            int realCount = buf.readInt();
            if (realCount == 0) {
                return ImmutablePackageContents.rehydrate(Optional.empty(), 0);
            }
            class_1799 filt = (class_1799)class_1799.field_48349.decode((Object)buf);
            return ImmutablePackageContents.rehydrate(Optional.of(filt), realCount);
        }
    };
    public static final class_9331<ImmutablePackageContents> DATA_COMPONENT_TYPE = new class_9331.class_9332().method_57881(CODEC).method_57882(STREAM_CODEC).method_57880();

    public static ImmutablePackageContents create(class_1799 stack, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Attempt to create PackageContents with count " + count + " for ItemStack " + String.valueOf(stack));
        }
        if (count == 0 || stack.method_7960()) {
            return EMPTY;
        }
        if (stack.method_7947() != 1) {
            stack = stack.method_46651(1);
        }
        return new ImmutablePackageContents(stack, count);
    }

    public TooltipStats computeTooltipStats() {
        ArrayList<ImmutablePackageContents> containers = new ArrayList<ImmutablePackageContents>();
        ImmutablePackageContents cont = this;
        do {
            containers.add(cont);
        } while ((cont = (ImmutablePackageContents)cont.stack.method_57824(DATA_COMPONENT_TYPE)) != null && !cont.isEmpty());
        ImmutablePackageContents last = (ImmutablePackageContents)containers.getLast();
        class_1799 rootContents = last.stack;
        if (rootContents.method_7960()) {
            return new TooltipStats(rootContents, 0, false);
        }
        int fullyMultipliedCount = last.count;
        boolean amplified = false;
        for (int i = 0; i < containers.size() - 1; ++i) {
            ImmutablePackageContents container = (ImmutablePackageContents)containers.get(i);
            int c = container.count;
            fullyMultipliedCount *= this.count;
            amplified |= this.count > 1;
        }
        return new TooltipStats(rootContents, fullyMultipliedCount, amplified);
    }

    public int calcRecursionLevel() {
        ImmutablePackageContents recur = (ImmutablePackageContents)this.stack.method_57824(DATA_COMPONENT_TYPE);
        if (recur == null) {
            return 0;
        }
        return 1 + recur.calcRecursionLevel();
    }

    public boolean isFull(PackageRules rules) {
        int maxCount = rules.maxInPackageTotal(this.stack);
        return maxCount == 0 || this.count == maxCount;
    }

    public float fillPercentage(PackageRules rules) {
        int maxCount = rules.maxInPackageTotal(this.stack);
        if (maxCount == 0) {
            return 1.0f;
        }
        return (float)this.count / (float)maxCount;
    }

    public boolean isEmpty() {
        return this.stack.method_7960() || this.count == 0;
    }

    public boolean canStackWith(class_1799 other) {
        return this.isEmpty() || other.method_7960() || class_1799.method_31577((class_1799)this.stack, (class_1799)other);
    }

    public boolean allowedToInsert(class_1799 other, PackageRules rules) {
        return rules.allowedToInsertInPackage(other) && this.canStackWith(other);
    }

    public InsertionResult withInsertion(class_1799 other, int maxToInsert, PackageRules rules) {
        if (other.method_7960() || !this.allowedToInsert(other, rules)) {
            return InsertionResult.none(this);
        }
        int remainingSpace = rules.maxInPackageTotal(other) - this.count;
        if (remainingSpace <= 0) {
            return InsertionResult.none(this);
        }
        int toInsert = Math.min(remainingSpace, Math.min(other.method_7947(), maxToInsert));
        if (toInsert == 0) {
            return InsertionResult.none(this);
        }
        int newCount = this.count + toInsert;
        if (this.isEmpty()) {
            return new InsertionResult(ImmutablePackageContents.create(other.method_46651(1), newCount), toInsert);
        }
        return new InsertionResult(ImmutablePackageContents.create(this.stack, newCount), toInsert);
    }

    public TakeResult withTake(int maxToTake, PackageRules rules) {
        if (this.isEmpty() || maxToTake == 0) {
            return TakeResult.none(this);
        }
        int toTake = Math.min(this.count, maxToTake);
        return new TakeResult(ImmutablePackageContents.create(this.stack, this.count - toTake), toTake);
    }

    public TakeResult withFilteredTake(class_1799 filter, int maxToTake, PackageRules rules) {
        if (!(this.isEmpty() || filter.method_7960() || class_1799.method_31577((class_1799)this.stack, (class_1799)filter))) {
            return TakeResult.none(this);
        }
        return this.withTake(maxToTake, rules);
    }

    private Optional<class_1799> stackForSerialization() {
        return this.stack.method_7960() ? Optional.empty() : Optional.of(this.stack.method_46651(1));
    }

    private static ImmutablePackageContents rehydrate(Optional<class_1799> stackOpt, int realCount) {
        return stackOpt.map(stack -> ImmutablePackageContents.create(stack, realCount)).orElse(EMPTY);
    }

    public class_2487 save(class_2487 in) {
        in.method_10566("PackageContents", (class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow());
        return in;
    }

    public static ImmutablePackageContents load(@Nullable class_2487 in) {
        if (in == null) {
            return EMPTY;
        }
        class_2520 t = in.method_10580("PackageContents");
        if (t == null) {
            return null;
        }
        return CODEC.parse((DynamicOps)class_2509.field_11560, (Object)t).result().orElse(EMPTY);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutablePackageContents other = (ImmutablePackageContents)o;
        return this.count == other.count && class_1799.method_31577((class_1799)this.stack, (class_1799)other.stack);
    }

    @Override
    public int hashCode() {
        return 31 * class_1799.method_57355((class_1799)this.stack) + this.count;
    }

    public record TooltipStats(class_1799 rootContents, int fullyMultipliedCount, boolean amplified) {
    }

    public record InsertionResult(ImmutablePackageContents newContents, int insertedAmount) {
        private static InsertionResult none(ImmutablePackageContents x) {
            return new InsertionResult(x, 0);
        }
    }

    public record TakeResult(ImmutablePackageContents newContents, int takenAmount) {
        private static TakeResult none(ImmutablePackageContents x) {
            return new TakeResult(x, 0);
        }
    }
}

