/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.craftless;

import agency.highlysuspect.quatlib.craftless.QuatlibBase;
import agency.highlysuspect.quatlib.craftless.Slf4jLogFacade;
import agency.highlysuspect.quatlib.craftless.config.ConfigSection;
import agency.highlysuspect.quatlib.craftless.config.WritableConfig;
import agency.highlysuspect.quatlib.craftless.facet.Id;
import agency.highlysuspect.quatlib.craftless.facet.Reg;
import agency.highlysuspect.quatlib.craftless.facet.RegType;
import agency.highlysuspect.quatlib.craftless.facet.RegistryGetter;
import agency.highlysuspect.quatlib.craftless.failure.FailureListener;
import agency.highlysuspect.quatlib.craftless.failure.FailureLogger;
import agency.highlysuspect.quatlib.craftless.failure.FailureRoot;
import agency.highlysuspect.quatlib.craftless.util.LogFacade;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class PackagesBase
implements RegistryGetter {
    public static final String MODID = "packages";
    public static final String NAME = "Packages";
    public static final LogFacade LOG = new Slf4jLogFacade("Packages");
    public FailureRoot failures = new FailureRoot("Packages").addListener((FailureListener)new FailureLogger(LOG));
    public ConfigSection configSchema;
    public WritableConfig config;
    private final Map<RegType<?>, Reg<?>> regs = new IdentityHashMap();
    protected static PackagesBase INST;

    public PackagesBase() {
        INST = this;
    }

    public static Id id(String path) {
        return new Id(MODID, path);
    }

    public void earlySetup() {
        this.configSchema = this.visitConfigSchema(new ConfigSection(NAME, new String[]{"Options for Packages."}));
        this.config = this.makeConfig(this.configSchema);
    }

    public Reg<?> getReg(RegType<?> type) {
        return this.regs.computeIfAbsent(type, arg_0 -> ((QuatlibBase)QuatlibBase.inst()).createReg(arg_0));
    }

    public abstract ConfigSection visitConfigSchema(ConfigSection var1);

    public abstract WritableConfig makeConfig(ConfigSection var1);

    public static PackagesBase inst() {
        return INST;
    }
}

