/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.backpacks.event;

import com.nemonotfound.nemos.backpacks.world.item.BackpackItems;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;

@EventBusSubscriber(modid="nemos_backpacks")
public class EventHandler {
    @SubscribeEvent
    public static void onLootTableLoadEvent(LootTableLoadEvent event) {
        ResourceKey resourceKey = event.getKey();
        LootTable lootTable = event.getTable();
        if (resourceKey == BuiltInLootTables.ABANDONED_MINESHAFT || resourceKey == BuiltInLootTables.SHIPWRECK_TREASURE || resourceKey == BuiltInLootTables.SIMPLE_DUNGEON || resourceKey == BuiltInLootTables.UNDERWATER_RUIN_BIG) {
            lootTable.addPool(EventHandler.createUpgradeTemplateLootPool(5, 2));
        }
        if (resourceKey == BuiltInLootTables.BURIED_TREASURE) {
            lootTable.addPool(EventHandler.createUpgradeTemplateLootPool(2, 5));
        }
        if (resourceKey == BuiltInLootTables.ANCIENT_CITY) {
            lootTable.addPool(EventHandler.createUpgradeTemplateLootPool(5, 9));
        }
        if (resourceKey == BuiltInLootTables.DESERT_PYRAMID || resourceKey == BuiltInLootTables.JUNGLE_TEMPLE || resourceKey == BuiltInLootTables.PILLAGER_OUTPOST) {
            lootTable.addPool(EventHandler.createUpgradeTemplateLootPool(3, 1));
        }
        if (resourceKey == BuiltInLootTables.UNDERWATER_RUIN_SMALL) {
            lootTable.addPool(EventHandler.createCommonUpgradeTemplateLootPool(2));
        }
        if (resourceKey == BuiltInLootTables.VILLAGE_WEAPONSMITH || resourceKey == BuiltInLootTables.VILLAGE_TOOLSMITH) {
            lootTable.addPool(EventHandler.createCommonUpgradeTemplateLootPool(1));
        }
        if (resourceKey == BuiltInLootTables.WOODLAND_MANSION) {
            lootTable.addPool(EventHandler.createUpgradeTemplateLootPool(4, 6));
        }
        if (resourceKey == BuiltInLootTables.TRIAL_CHAMBERS_REWARD_RARE) {
            lootTable.addPool(EventHandler.createRareUpgradeTemplateLootPool(5));
        }
        if (resourceKey == BuiltInLootTables.TRIAL_CHAMBERS_REWARD_COMMON) {
            lootTable.addPool(EventHandler.createCommonUpgradeTemplateLootPool(4));
        }
        if (resourceKey == BuiltInLootTables.TRIAL_CHAMBERS_REWARD_UNIQUE) {
            lootTable.addPool(EventHandler.createRareUpgradeTemplateLootPool(7));
        }
        if (resourceKey == BuiltInLootTables.TRIAL_CHAMBERS_REWARD_OMINOUS_RARE) {
            lootTable.addPool(EventHandler.createRareUpgradeTemplateLootPool(6));
        }
        if (resourceKey == BuiltInLootTables.TRIAL_CHAMBERS_REWARD_OMINOUS_COMMON) {
            lootTable.addPool(EventHandler.createCommonUpgradeTemplateLootPool(5));
        }
        if (resourceKey == BuiltInLootTables.TRIAL_CHAMBERS_REWARD_OMINOUS_UNIQUE) {
            lootTable.addPool(EventHandler.createRareUpgradeTemplateLootPool(8));
        }
    }

    private static LootPool createCommonUpgradeTemplateLootPool(int commonWeight) {
        int fullWeight = 100;
        int emptyItemWeight = fullWeight - 2 * commonWeight;
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)BackpackItems.COPPER_UPGRADE_SMITHING_TEMPLATE.get())).setWeight(commonWeight)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)BackpackItems.IRON_UPGRADE_SMITHING_TEMPLATE.get())).setWeight(commonWeight)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(emptyItemWeight)).build();
    }

    private static LootPool createRareUpgradeTemplateLootPool(int rareWeight) {
        int fullWeight = 100;
        int emptyItemWeight = fullWeight - 2 * rareWeight;
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)BackpackItems.GOLD_UPGRADE_SMITHING_TEMPLATE.get())).setWeight(rareWeight)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)BackpackItems.DIAMOND_UPGRADE_SMITHING_TEMPLATE.get())).setWeight(rareWeight)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(emptyItemWeight)).build();
    }

    private static LootPool createUpgradeTemplateLootPool(int commonWeight, int rareWeight) {
        int fullWeight = 100;
        int emptyItemWeight = fullWeight - 2 * commonWeight - 2 * rareWeight;
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)BackpackItems.COPPER_UPGRADE_SMITHING_TEMPLATE.get())).setWeight(commonWeight)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)BackpackItems.IRON_UPGRADE_SMITHING_TEMPLATE.get())).setWeight(commonWeight)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)BackpackItems.GOLD_UPGRADE_SMITHING_TEMPLATE.get())).setWeight(rareWeight)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)BackpackItems.DIAMOND_UPGRADE_SMITHING_TEMPLATE.get())).setWeight(rareWeight)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(emptyItemWeight)).build();
    }
}

