/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.backpacks.world.item;

import com.nemonotfound.nemos.backpacks.network.protocol.game.BackpackOpenedPacket;
import com.nemonotfound.nemos.backpacks.tags.BackpackItemTags;
import com.nemonotfound.nemos.backpacks.world.inventory.BackpackMenu;
import com.nemonotfound.nemos.backpacks.world.item.BackpackMaterial;
import commonnetwork.api.Dispatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackItem
extends Item {
    private static final Component TITLE = Component.translatable((String)"nemos_backpacks.container.backpack");
    private final BackpackMaterial backpackMaterial;
    private final DyeColor dyeColor;

    public BackpackItem(Item.Properties properties, BackpackMaterial backpackMaterial, DyeColor dyeColor) {
        super(properties);
        this.backpackMaterial = backpackMaterial;
        this.dyeColor = dyeColor;
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack backpackItemStack = this.getBackpackItemStack(player, interactionHand);
        if (level instanceof ServerLevel) {
            Dispatcher.sendToClient((Object)new BackpackOpenedPacket(backpackItemStack), (ServerPlayer)((ServerPlayer)player));
        }
        player.openMenu(this.createScreenHandlerFactory(backpackItemStack));
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResult.SUCCESS;
    }

    private ItemStack getBackpackItemStack(Player player, InteractionHand interactionHand) {
        if (interactionHand == null) {
            Inventory playerInventory = player.getInventory();
            return playerInventory.getItem(46);
        }
        return player.getItemInHand(interactionHand);
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public BackpackMaterial getBackpackMaterial() {
        return this.backpackMaterial;
    }

    @Nullable
    public MenuProvider createScreenHandlerFactory(ItemStack itemStack) {
        DataComponentMap components = itemStack.getComponents();
        ItemContainerContents itemContainerContents = (ItemContainerContents)components.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        SimpleContainer container = new SimpleContainer(9 * this.backpackMaterial.getRows());
        List items = itemContainerContents.stream().toList();
        for (int i = 0; i < items.size(); ++i) {
            container.setItem(i, (ItemStack)items.get(i));
        }
        return new SimpleMenuProvider((syncId, playerInventory, player1) -> switch (this.backpackMaterial) {
            default -> throw new MatchException(null, null);
            case BackpackMaterial.STRING -> BackpackMenu.defaultBackpack(syncId, playerInventory, itemStack, (Container)container);
            case BackpackMaterial.COPPER -> BackpackMenu.copperBackpack(syncId, playerInventory, itemStack, (Container)container);
            case BackpackMaterial.IRON -> BackpackMenu.ironBackpack(syncId, playerInventory, itemStack, (Container)container);
            case BackpackMaterial.GOLD -> BackpackMenu.goldenBackpack(syncId, playerInventory, itemStack, (Container)container);
            case BackpackMaterial.DIAMOND -> BackpackMenu.diamondBackpack(syncId, playerInventory, itemStack, (Container)container);
            case BackpackMaterial.NETHERITE -> BackpackMenu.netheriteBackpack(syncId, playerInventory, itemStack, (Container)container);
        }, TITLE);
    }

    public void onDestroyed(ItemEntity itemEntity) {
        ItemContainerContents itemContainerContents = (ItemContainerContents)this.components().getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        itemEntity.getItem().set(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, (Iterable)itemContainerContents.nonEmptyItemsCopy());
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack backpack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        return this.overrideStackingLogic(backpack, slot.getItem(), slot, false, action, player);
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack backpack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        return this.overrideStackingLogic(backpack, other, slot, true, action, player);
    }

    private boolean overrideStackingLogic(ItemStack backpack, ItemStack other, Slot slot, boolean isSlotModified, ClickAction action, Player player) {
        if (other.is(BackpackItemTags.BACKPACKS) || action != ClickAction.PRIMARY || other.isEmpty()) {
            return false;
        }
        ItemContainerContents itemContainerContents = (ItemContainerContents)backpack.get(DataComponents.CONTAINER);
        if (itemContainerContents == null) {
            return false;
        }
        SimpleContainer container = this.getContainer(itemContainerContents);
        if ((!isSlotModified || slot.allowModification(player)) && this.tryMoveItem(container, other)) {
            this.playInsertSound((Entity)player);
        } else {
            this.playInsertFailSound((Entity)player);
        }
        this.storeItemsIntoBackpack(container, backpack, player);
        return true;
    }

    private SimpleContainer getContainer(ItemContainerContents itemContainerContents) {
        SimpleContainer container = new SimpleContainer(9 * this.backpackMaterial.getRows());
        List items = itemContainerContents.stream().toList();
        for (int i = 0; i < items.size(); ++i) {
            container.setItem(i, (ItemStack)items.get(i));
        }
        return container;
    }

    private boolean tryMoveItem(SimpleContainer container, ItemStack itemToMove) {
        boolean itemWasMoved;
        ItemStack remainingStack = container.addItem(itemToMove);
        boolean bl = itemWasMoved = remainingStack.isEmpty() || remainingStack.getCount() != itemToMove.getCount();
        if (!itemWasMoved) {
            return false;
        }
        itemToMove.setCount(remainingStack.getCount());
        return true;
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertFailSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT_FAIL, 1.0f, 1.0f);
    }

    private void storeItemsIntoBackpack(SimpleContainer container, ItemStack backpack, Player player) {
        ArrayList<ItemStack> containerItems = new ArrayList<ItemStack>();
        for (int i = 0; i < container.getContainerSize(); ++i) {
            containerItems.add(container.getItem(i));
        }
        backpack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(containerItems));
        this.broadcastChangesOnContainerMenu(player);
    }

    private void broadcastChangesOnContainerMenu(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        abstractContainerMenu.slotsChanged((Container)player.getInventory());
    }

    public static Item getByColorAndBackpackMaterial(DyeColor color, BackpackMaterial backpackMaterial) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"nemos_backpacks", (String)BackpackItem.getItemName(color, backpackMaterial));
        Item item = (Item)BuiltInRegistries.ITEM.getValue(resourceLocation);
        if (item == Items.AIR) {
            throw new IllegalArgumentException("Missing item: " + String.valueOf(resourceLocation));
        }
        return item;
    }

    public static Item getByBackpackMaterial(BackpackMaterial backpackMaterial) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"nemos_backpacks", (String)BackpackItem.getItemName(backpackMaterial));
        Item item = (Item)BuiltInRegistries.ITEM.getValue(resourceLocation);
        if (item == Items.AIR) {
            throw new IllegalArgumentException("Missing item: " + String.valueOf(resourceLocation));
        }
        return item;
    }

    private static String getItemName(DyeColor color, BackpackMaterial backpackMaterial) {
        String materialPrefix = switch (backpackMaterial) {
            default -> throw new MatchException(null, null);
            case BackpackMaterial.STRING -> "";
            case BackpackMaterial.COPPER -> "copper";
            case BackpackMaterial.IRON -> "iron";
            case BackpackMaterial.GOLD -> "golden";
            case BackpackMaterial.DIAMOND -> "diamond";
            case BackpackMaterial.NETHERITE -> "netherite";
        };
        return color.getName() + (String)(!materialPrefix.isEmpty() ? "_" + materialPrefix : "") + "_backpack";
    }

    private static String getItemName(BackpackMaterial backpackMaterial) {
        String materialPrefix = switch (backpackMaterial) {
            default -> throw new MatchException(null, null);
            case BackpackMaterial.STRING -> "";
            case BackpackMaterial.COPPER -> "copper";
            case BackpackMaterial.IRON -> "iron";
            case BackpackMaterial.GOLD -> "golden";
            case BackpackMaterial.DIAMOND -> "diamond";
            case BackpackMaterial.NETHERITE -> "netherite";
        };
        return (String)(!materialPrefix.isEmpty() ? materialPrefix + "_" : "") + "backpack";
    }
}

