/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.backpacks.mixin;

import com.nemonotfound.nemos.backpacks.client.BackpackKeyMappings;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin {
    @Shadow
    @Nullable
    protected Slot hoveredSlot;
    @Shadow
    @Final
    protected AbstractContainerMenu menu;

    @Shadow
    protected abstract void slotClicked(Slot var1, int var2, int var3, ClickType var4);

    @Inject(method={"checkHotbarMouseClicked"}, at={@At(value="HEAD")})
    private void handleBackpackSwapMouseClicked(MouseButtonEvent event, CallbackInfo ci) {
        if (this.hoveredSlot == null || !this.menu.getCarried().isEmpty()) {
            return;
        }
        if (BackpackKeyMappings.SWAP_BACKPACK.get().matchesMouse(event)) {
            this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, 46, ClickType.SWAP);
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")})
    private void handleBackpackSwapKeyPRessed(KeyEvent event, CallbackInfoReturnable<Boolean> cir) {
        if (this.hoveredSlot == null || !this.menu.getCarried().isEmpty()) {
            return;
        }
        if (BackpackKeyMappings.SWAP_BACKPACK.get().matches(event)) {
            this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, 46, ClickType.SWAP);
        }
    }
}

