/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.backpacks.mixin;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    @Nullable
    protected abstract Player getCameraPlayer();

    @Inject(method={"renderHotbar"}, at={@At(value="HEAD")})
    private void renderCarriedBackpack(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        Player player = this.getCameraPlayer();
        if (player == null || !this.minecraft.gameMode.canHurtPlayer()) {
            return;
        }
        ItemStack backpackItemStack = player.getInventory().getItem(46);
        if (backpackItemStack.isEmpty()) {
            return;
        }
        ResourceLocation backpackLocation = BuiltInRegistries.ITEM.getKey((Object)backpackItemStack.getItem());
        ResourceLocation textureLocation = ResourceLocation.fromNamespaceAndPath((String)backpackLocation.getNamespace(), (String)("hud/backpack/" + backpackLocation.getPath()));
        int x = guiGraphics.guiWidth() / 2 - 5;
        int y = guiGraphics.guiHeight() - 49;
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, textureLocation, x, y, 9, 9);
    }
}

