/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.backpacks.client.gui.screens.inventory;

import com.nemonotfound.nemos.backpacks.client.BackpackKeyMappings;
import com.nemonotfound.nemos.backpacks.world.inventory.BackpackMenu;
import com.nemonotfound.nemos.backpacks.world.item.BackpackMaterial;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;

public class BackpackScreen
extends AbstractContainerScreen<BackpackMenu> {
    private static final Map<DyeColor, ResourceLocation> backgroundTextureMap = new HashMap<DyeColor, ResourceLocation>();
    private static final Map<BackpackMaterial, ResourceLocation> overlayTextureMap = new HashMap<BackpackMaterial, ResourceLocation>();
    private final ResourceLocation backpackBackground;
    private final ResourceLocation backpackOverlay;
    private final int containerRows;

    public BackpackScreen(BackpackMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.containerRows = menu.getRowCount();
        this.imageHeight = 114 + this.containerRows * 18;
        this.inventoryLabelY = this.imageHeight - 94;
        this.backpackOverlay = overlayTextureMap.get((Object)menu.getBackpackMaterial());
        this.backpackBackground = backgroundTextureMap.get(menu.getDyeColor());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int leftPos = (this.width - this.imageWidth) / 2;
        int topPos = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.backpackBackground, leftPos, topPos, 0.0f, 0.0f, this.imageWidth, this.containerRows * 18 + 17, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.backpackBackground, leftPos, topPos + this.containerRows * 18 + 17, 0.0f, 126.0f, this.imageWidth, 96, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.backpackOverlay, leftPos, topPos, 0.0f, 0.0f, this.imageWidth, this.containerRows * 18 + 17, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.backpackOverlay, leftPos, topPos + this.containerRows * 18 + 17, 0.0f, 126.0f, this.imageWidth, 96, 256, 256);
    }

    public boolean keyPressed(@NotNull KeyEvent event) {
        if (BackpackKeyMappings.INTERACT_BACKPACK.get().matches(event)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean mouseClicked(@NotNull MouseButtonEvent event, boolean isDoubleClick) {
        if (BackpackKeyMappings.INTERACT_BACKPACK.get().matchesMouse(event)) {
            this.onClose();
            return true;
        }
        return super.mouseClicked(event, isDoubleClick);
    }

    private static ResourceLocation getBackgroundTextureLocation(String textureFileName) {
        return ResourceLocation.fromNamespaceAndPath((String)"nemos_backpacks", (String)String.format("textures/gui/container/backpack/background/%s.png", textureFileName));
    }

    private static ResourceLocation getOverlayTextureLocation(String textureFileName) {
        return ResourceLocation.fromNamespaceAndPath((String)"nemos_backpacks", (String)String.format("textures/gui/container/backpack/overlay/%s.png", textureFileName));
    }

    static {
        overlayTextureMap.put(BackpackMaterial.STRING, BackpackScreen.getOverlayTextureLocation("default_backpack_overlay"));
        overlayTextureMap.put(BackpackMaterial.COPPER, BackpackScreen.getOverlayTextureLocation("copper_backpack_overlay"));
        overlayTextureMap.put(BackpackMaterial.IRON, BackpackScreen.getOverlayTextureLocation("iron_backpack_overlay"));
        overlayTextureMap.put(BackpackMaterial.GOLD, BackpackScreen.getOverlayTextureLocation("golden_backpack_overlay"));
        overlayTextureMap.put(BackpackMaterial.DIAMOND, BackpackScreen.getOverlayTextureLocation("diamond_backpack_overlay"));
        overlayTextureMap.put(BackpackMaterial.NETHERITE, BackpackScreen.getOverlayTextureLocation("netherite_backpack_overlay"));
        backgroundTextureMap.put(null, BackpackScreen.getBackgroundTextureLocation("default_backpack_background"));
        backgroundTextureMap.put(DyeColor.WHITE, BackpackScreen.getBackgroundTextureLocation("white_backpack_background"));
        backgroundTextureMap.put(DyeColor.LIGHT_GRAY, BackpackScreen.getBackgroundTextureLocation("light_gray_backpack_background"));
        backgroundTextureMap.put(DyeColor.GRAY, BackpackScreen.getBackgroundTextureLocation("gray_backpack_background"));
        backgroundTextureMap.put(DyeColor.BLACK, BackpackScreen.getBackgroundTextureLocation("black_backpack_background"));
        backgroundTextureMap.put(DyeColor.BROWN, BackpackScreen.getBackgroundTextureLocation("brown_backpack_background"));
        backgroundTextureMap.put(DyeColor.RED, BackpackScreen.getBackgroundTextureLocation("red_backpack_background"));
        backgroundTextureMap.put(DyeColor.ORANGE, BackpackScreen.getBackgroundTextureLocation("orange_backpack_background"));
        backgroundTextureMap.put(DyeColor.YELLOW, BackpackScreen.getBackgroundTextureLocation("yellow_backpack_background"));
        backgroundTextureMap.put(DyeColor.LIME, BackpackScreen.getBackgroundTextureLocation("lime_backpack_background"));
        backgroundTextureMap.put(DyeColor.GREEN, BackpackScreen.getBackgroundTextureLocation("green_backpack_background"));
        backgroundTextureMap.put(DyeColor.CYAN, BackpackScreen.getBackgroundTextureLocation("cyan_backpack_background"));
        backgroundTextureMap.put(DyeColor.LIGHT_BLUE, BackpackScreen.getBackgroundTextureLocation("light_blue_backpack_background"));
        backgroundTextureMap.put(DyeColor.BLUE, BackpackScreen.getBackgroundTextureLocation("blue_backpack_background"));
        backgroundTextureMap.put(DyeColor.PURPLE, BackpackScreen.getBackgroundTextureLocation("purple_backpack_background"));
        backgroundTextureMap.put(DyeColor.MAGENTA, BackpackScreen.getBackgroundTextureLocation("magenta_backpack_background"));
        backgroundTextureMap.put(DyeColor.PINK, BackpackScreen.getBackgroundTextureLocation("pink_backpack_background"));
    }
}

