/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.backpacks.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.nemonotfound.nemos.backpacks.world.item.BackpackItem;
import java.util.Optional;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Inventory.class})
public class InventoryMixin {
    @Shadow
    @Final
    public Player player;
    @Unique
    private ItemStack nemosBackpacks$backpackItemStack = ItemStack.EMPTY;

    @Inject(method={"setItem"}, at={@At(value="TAIL")})
    private void setBackpackItem(int index, ItemStack stack, CallbackInfo ci) {
        if (index == 46 && (stack.getItem() instanceof BackpackItem || stack.isEmpty())) {
            this.nemosBackpacks$backpackItemStack = stack;
        }
    }

    @Inject(method={"save"}, at={@At(value="TAIL")})
    private void saveBackpack(ValueOutput.TypedOutputList<ItemStackWithSlot> output, CallbackInfo ci) {
        if (!this.nemosBackpacks$backpackItemStack.isEmpty()) {
            output.add((Object)new ItemStackWithSlot(46, this.nemosBackpacks$backpackItemStack));
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void loadBackpack(ValueInput.TypedInputList<ItemStackWithSlot> input, CallbackInfo ci) {
        this.nemosBackpacks$backpackItemStack = ItemStack.EMPTY;
        Optional<ItemStackWithSlot> optionalBackpackItem = input.stream().filter(itemStackWithSlot -> itemStackWithSlot.slot() == 46).findFirst();
        optionalBackpackItem.ifPresent(itemStackWithSlot -> {
            this.nemosBackpacks$backpackItemStack = itemStackWithSlot.stack();
        });
    }

    @ModifyReturnValue(method={"getItem"}, at={@At(value="RETURN")})
    private ItemStack getBackpackItem(ItemStack original, @Local(argsOnly=true) int index) {
        if (original.isEmpty() && index == 46) {
            return this.nemosBackpacks$backpackItemStack;
        }
        return original;
    }

    @ModifyReturnValue(method={"removeItem(II)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")})
    private ItemStack removeBackpackItem(ItemStack original, @Local(ordinal=0, argsOnly=true) int index, @Local(ordinal=1, argsOnly=true) int count) {
        if (original.isEmpty() && index == 46 && !this.nemosBackpacks$backpackItemStack.isEmpty()) {
            return this.nemosBackpacks$backpackItemStack.split(count);
        }
        return original;
    }

    @Inject(method={"removeItem(Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="RETURN")})
    private void removeBackpackItem(ItemStack stack, CallbackInfo ci) {
        if (stack == this.nemosBackpacks$backpackItemStack) {
            this.nemosBackpacks$backpackItemStack = ItemStack.EMPTY;
        }
    }

    @ModifyReturnValue(method={"removeItemNoUpdate"}, at={@At(value="RETURN")})
    private ItemStack removeBackpackNoUpdate(ItemStack original, @Local(argsOnly=true) int index) {
        if (original.isEmpty() && index == 46) {
            this.nemosBackpacks$backpackItemStack = ItemStack.EMPTY;
            return this.nemosBackpacks$backpackItemStack;
        }
        return original;
    }

    @ModifyReturnValue(method={"getContainerSize"}, at={@At(value="RETURN")})
    private int getContainerSize(int original) {
        return original + 1;
    }

    @ModifyReturnValue(method={"isEmpty"}, at={@At(value="RETURN")})
    private boolean isEmpty(boolean original) {
        if (original) {
            return this.nemosBackpacks$backpackItemStack == ItemStack.EMPTY;
        }
        return false;
    }

    @Inject(method={"dropAll"}, at={@At(value="TAIL")})
    private void dropBackpackItem(CallbackInfo ci) {
        if (!this.nemosBackpacks$backpackItemStack.isEmpty()) {
            this.player.drop(this.nemosBackpacks$backpackItemStack, true, false);
            this.nemosBackpacks$backpackItemStack = ItemStack.EMPTY;
        }
    }
}

