/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.backpacks.network.protocol.game;

import com.nemonotfound.nemos.backpacks.world.item.BackpackItem;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class BackpackSwapPacket {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"nemos_backpacks", (String)"backpack_swap");
    public static final StreamCodec<FriendlyByteBuf, BackpackSwapPacket> STREAM_CODEC = StreamCodec.ofMember(BackpackSwapPacket::encode, BackpackSwapPacket::new);

    public BackpackSwapPacket() {
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public BackpackSwapPacket(FriendlyByteBuf buf) {
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public static void handle(PacketContext<BackpackSwapPacket> context) {
        if (Side.CLIENT.equals((Object)context.side())) {
            return;
        }
        ServerPlayer player = context.sender();
        if (!player.isSpectator()) {
            Inventory playerInventory = player.getInventory();
            ItemStack backpackItemstack = playerInventory.getItem(46);
            ItemStack itemStackInHand = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (!itemStackInHand.isEmpty() && !(itemStackInHand.getItem() instanceof BackpackItem)) {
                return;
            }
            playerInventory.setItem(46, itemStackInHand);
            player.setItemInHand(InteractionHand.MAIN_HAND, backpackItemstack);
            player.stopUsingItem();
        }
    }
}

