/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.backpacks.world.inventory;

import com.nemonotfound.nemos.backpacks.helper.Backpacker;
import com.nemonotfound.nemos.backpacks.world.inventory.BackpackMenuTypes;
import com.nemonotfound.nemos.backpacks.world.inventory.BackpackSlot;
import com.nemonotfound.nemos.backpacks.world.item.BackpackItem;
import com.nemonotfound.nemos.backpacks.world.item.BackpackMaterial;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackMenu
extends AbstractContainerMenu {
    private final Container container;
    private final int containerRows;
    private final ItemStack itemStack;
    private final Inventory playerInventory;

    public static BackpackMenu defaultBackpack(int containerId, Inventory playerInventory) {
        return new BackpackMenu(BackpackMenuTypes.DEFAULT_BACKPACK.get(), containerId, playerInventory, 1);
    }

    public static BackpackMenu defaultBackpack(int containerId, Inventory playerInventory, ItemStack itemStack, Container container) {
        return new BackpackMenu(BackpackMenuTypes.DEFAULT_BACKPACK.get(), containerId, playerInventory, itemStack, container, 1);
    }

    public static BackpackMenu copperBackpack(int containerId, Inventory playerInventory) {
        return new BackpackMenu(BackpackMenuTypes.COPPER_BACKPACK.get(), containerId, playerInventory, 2);
    }

    public static BackpackMenu copperBackpack(int containerId, Inventory playerInventory, ItemStack itemStack, Container container) {
        return new BackpackMenu(BackpackMenuTypes.COPPER_BACKPACK.get(), containerId, playerInventory, itemStack, container, 2);
    }

    public static BackpackMenu ironBackpack(int containerId, Inventory playerInventory) {
        return new BackpackMenu(BackpackMenuTypes.IRON_BACKPACK.get(), containerId, playerInventory, 3);
    }

    public static BackpackMenu ironBackpack(int containerId, Inventory playerInventory, ItemStack itemStack, Container container) {
        return new BackpackMenu(BackpackMenuTypes.IRON_BACKPACK.get(), containerId, playerInventory, itemStack, container, 3);
    }

    public static BackpackMenu goldenBackpack(int containerId, Inventory playerInventory) {
        return new BackpackMenu(BackpackMenuTypes.GOLDEN_BACKPACK.get(), containerId, playerInventory, 4);
    }

    public static BackpackMenu goldenBackpack(int containerId, Inventory playerInventory, ItemStack itemStack, Container container) {
        return new BackpackMenu(BackpackMenuTypes.GOLDEN_BACKPACK.get(), containerId, playerInventory, itemStack, container, 4);
    }

    public static BackpackMenu diamondBackpack(int containerId, Inventory playerInventory) {
        return new BackpackMenu(BackpackMenuTypes.DIAMOND_BACKPACK.get(), containerId, playerInventory, 5);
    }

    public static BackpackMenu diamondBackpack(int containerId, Inventory playerInventory, ItemStack itemStack, Container container) {
        return new BackpackMenu(BackpackMenuTypes.DIAMOND_BACKPACK.get(), containerId, playerInventory, itemStack, container, 5);
    }

    public static BackpackMenu netheriteBackpack(int containerId, Inventory playerInventory) {
        return new BackpackMenu(BackpackMenuTypes.NETHERITE_BACKPACK.get(), containerId, playerInventory, 6);
    }

    public static BackpackMenu netheriteBackpack(int containerId, Inventory playerInventory, ItemStack itemStack, Container container) {
        return new BackpackMenu(BackpackMenuTypes.NETHERITE_BACKPACK.get(), containerId, playerInventory, itemStack, container, 6);
    }

    private BackpackMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, int rows) {
        this(menuType, containerId, playerInventory, ((Backpacker)playerInventory.player).nemosBackpacks$getLastOpenedBackpack(), (Container)new SimpleContainer(9 * rows), rows);
    }

    public BackpackMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory, ItemStack itemStack, Container container, int rows) {
        super(menuType, containerId);
        BackpackMenu.checkContainerSize((Container)container, (int)(rows * 9));
        this.container = container;
        this.containerRows = rows;
        this.itemStack = itemStack;
        this.playerInventory = playerInventory;
        container.startOpen((ContainerUser)playerInventory.player);
        int xOffset = 8;
        int yOffset = 18;
        int gapBetweenContainerAndInventory = 13;
        this.addBackpackGrid(container, xOffset, yOffset);
        int inventoryYOffset = yOffset + this.containerRows * yOffset + gapBetweenContainerAndInventory;
        this.addStandardInventorySlots((Container)playerInventory, xOffset, inventoryYOffset);
    }

    private void addBackpackGrid(Container container, int xOffset, int yOffset) {
        for (int rowIndex = 0; rowIndex < this.containerRows; ++rowIndex) {
            for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
                this.addSlot(new BackpackSlot(container, slotIndex + rowIndex * 9, xOffset + slotIndex * yOffset, yOffset + rowIndex * yOffset));
            }
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotItemStack = slot.getItem();
            itemstack = slotItemStack.copy();
            if (index < this.container.getContainerSize() ? !this.moveItemStackTo(slotItemStack, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(slotItemStack, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (slotItemStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        this.storeBackpackItems();
        return itemstack;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.container.stillValid(player);
    }

    public void clicked(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        if (this.isItemBackpackInUse(slotId, clickType, button)) {
            return;
        }
        super.clicked(slotId, button, clickType, player);
        this.storeBackpackItems();
    }

    private boolean isItemBackpackInUse(int slotId, ClickType clickType, int button) {
        int containerSize = this.container.getContainerSize();
        int playerInventoryContainerSize = 27;
        int hotbarSize = 9;
        int hotbarStartIndex = containerSize + playerInventoryContainerSize;
        int hotbarEndIndex = hotbarStartIndex + hotbarSize - 1;
        boolean isSlotIdWithinHotbarBounds = slotId >= hotbarStartIndex && slotId <= hotbarEndIndex;
        return isSlotIdWithinHotbarBounds && this.playerInventory.getItem(slotId - containerSize - playerInventoryContainerSize) == this.itemStack || slotId >= 9 && clickType.equals((Object)ClickType.SWAP) && this.playerInventory.getItem(button) == this.itemStack;
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.storeBackpackItems();
        this.container.stopOpen((ContainerUser)player);
    }

    private void storeBackpackItems() {
        ArrayList<ItemStack> containerItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            containerItems.add(this.container.getItem(i));
        }
        this.itemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(containerItems));
    }

    public int getRowCount() {
        return this.containerRows;
    }

    public BackpackMaterial getBackpackMaterial() {
        Item item = this.itemStack.getItem();
        if (!(item instanceof BackpackItem)) {
            return null;
        }
        return ((BackpackItem)item).getBackpackMaterial();
    }

    public DyeColor getDyeColor() {
        Item item = this.itemStack.getItem();
        if (!(item instanceof BackpackItem)) {
            return null;
        }
        return ((BackpackItem)item).getDyeColor();
    }
}

