/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.backpacks.world.item;

import com.nemonotfound.nemos.backpacks.network.protocol.game.BackpackOpenedPacket;
import com.nemonotfound.nemos.backpacks.tags.BackpackItemTags;
import com.nemonotfound.nemos.backpacks.world.inventory.BackpackMenu;
import com.nemonotfound.nemos.backpacks.world.item.BackpackMaterial;
import commonnetwork.api.Dispatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3908;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_747;
import net.minecraft.class_7923;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackItem
extends class_1792 {
    private static final class_2561 TITLE = class_2561.method_43471((String)"nemos_backpacks.container.backpack");
    private final BackpackMaterial backpackMaterial;
    private final class_1767 dyeColor;

    public BackpackItem(class_1792.class_1793 properties, BackpackMaterial backpackMaterial, class_1767 dyeColor) {
        super(properties);
        this.backpackMaterial = backpackMaterial;
        this.dyeColor = dyeColor;
    }

    @NotNull
    public class_1269 method_7836(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_1268 interactionHand) {
        class_1799 backpackItemStack = this.getBackpackItemStack(player, interactionHand);
        if (level instanceof class_3218) {
            Dispatcher.sendToClient((Object)new BackpackOpenedPacket(backpackItemStack), (class_3222)((class_3222)player));
        }
        player.method_17355(this.createScreenHandlerFactory(backpackItemStack));
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        return class_1269.field_5812;
    }

    private class_1799 getBackpackItemStack(class_1657 player, class_1268 interactionHand) {
        if (interactionHand == null) {
            class_1661 playerInventory = player.method_31548();
            return playerInventory.method_5438(46);
        }
        return player.method_5998(interactionHand);
    }

    public class_1767 getDyeColor() {
        return this.dyeColor;
    }

    public BackpackMaterial getBackpackMaterial() {
        return this.backpackMaterial;
    }

    @Nullable
    public class_3908 createScreenHandlerFactory(class_1799 itemStack) {
        class_9323 components = itemStack.method_57353();
        class_9288 itemContainerContents = (class_9288)components.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        class_1277 container = new class_1277(9 * this.backpackMaterial.getRows());
        List items = itemContainerContents.method_57489().toList();
        for (int i = 0; i < items.size(); ++i) {
            container.method_5447(i, (class_1799)items.get(i));
        }
        return new class_747((syncId, playerInventory, player1) -> switch (this.backpackMaterial) {
            default -> throw new MatchException(null, null);
            case BackpackMaterial.STRING -> BackpackMenu.defaultBackpack(syncId, playerInventory, itemStack, (class_1263)container);
            case BackpackMaterial.COPPER -> BackpackMenu.copperBackpack(syncId, playerInventory, itemStack, (class_1263)container);
            case BackpackMaterial.IRON -> BackpackMenu.ironBackpack(syncId, playerInventory, itemStack, (class_1263)container);
            case BackpackMaterial.GOLD -> BackpackMenu.goldenBackpack(syncId, playerInventory, itemStack, (class_1263)container);
            case BackpackMaterial.DIAMOND -> BackpackMenu.diamondBackpack(syncId, playerInventory, itemStack, (class_1263)container);
            case BackpackMaterial.NETHERITE -> BackpackMenu.netheriteBackpack(syncId, playerInventory, itemStack, (class_1263)container);
        }, TITLE);
    }

    public void method_33261(class_1542 itemEntity) {
        class_9288 itemContainerContents = (class_9288)this.method_57347().method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        itemEntity.method_6983().method_57379(class_9334.field_49622, (Object)class_9288.field_49334);
        class_5328.method_33263((class_1542)itemEntity, (Iterable)itemContainerContents.method_59715());
    }

    public boolean method_31565(@NotNull class_1799 backpack, @NotNull class_1735 slot, @NotNull class_5536 action, @NotNull class_1657 player) {
        return this.overrideStackingLogic(backpack, slot.method_7677(), slot, false, action, player);
    }

    public boolean method_31566(@NotNull class_1799 backpack, @NotNull class_1799 other, @NotNull class_1735 slot, @NotNull class_5536 action, @NotNull class_1657 player, @NotNull class_5630 access) {
        return this.overrideStackingLogic(backpack, other, slot, true, action, player);
    }

    private boolean overrideStackingLogic(class_1799 backpack, class_1799 other, class_1735 slot, boolean isSlotModified, class_5536 action, class_1657 player) {
        if (other.method_31573(BackpackItemTags.BACKPACKS) || action != class_5536.field_27013 || other.method_7960()) {
            return false;
        }
        class_9288 itemContainerContents = (class_9288)backpack.method_58694(class_9334.field_49622);
        if (itemContainerContents == null) {
            return false;
        }
        class_1277 container = this.getContainer(itemContainerContents);
        if ((!isSlotModified || slot.method_32754(player)) && this.tryMoveItem(container, other)) {
            this.playInsertSound((class_1297)player);
        } else {
            this.playInsertFailSound((class_1297)player);
        }
        this.storeItemsIntoBackpack(container, backpack, player);
        return true;
    }

    private class_1277 getContainer(class_9288 itemContainerContents) {
        class_1277 container = new class_1277(9 * this.backpackMaterial.getRows());
        List items = itemContainerContents.method_57489().toList();
        for (int i = 0; i < items.size(); ++i) {
            container.method_5447(i, (class_1799)items.get(i));
        }
        return container;
    }

    private boolean tryMoveItem(class_1277 container, class_1799 itemToMove) {
        boolean itemWasMoved;
        class_1799 remainingStack = container.method_5491(itemToMove);
        boolean bl = itemWasMoved = remainingStack.method_7960() || remainingStack.method_7947() != itemToMove.method_7947();
        if (!itemWasMoved) {
            return false;
        }
        itemToMove.method_7939(remainingStack.method_7947());
        return true;
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertFailSound(class_1297 entity) {
        entity.method_5783(class_3417.field_52372, 1.0f, 1.0f);
    }

    private void storeItemsIntoBackpack(class_1277 container, class_1799 backpack, class_1657 player) {
        ArrayList<class_1799> containerItems = new ArrayList<class_1799>();
        for (int i = 0; i < container.method_5439(); ++i) {
            containerItems.add(container.method_5438(i));
        }
        backpack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(containerItems));
        this.broadcastChangesOnContainerMenu(player);
    }

    private void broadcastChangesOnContainerMenu(class_1657 player) {
        class_1703 abstractContainerMenu = player.field_7512;
        abstractContainerMenu.method_7609((class_1263)player.method_31548());
    }

    public static class_1792 getByColorAndBackpackMaterial(class_1767 color, BackpackMaterial backpackMaterial) {
        class_2960 resourceLocation = class_2960.method_60655((String)"nemos_backpacks", (String)BackpackItem.getItemName(color, backpackMaterial));
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(resourceLocation);
        if (item == class_1802.field_8162) {
            throw new IllegalArgumentException("Missing item: " + String.valueOf(resourceLocation));
        }
        return item;
    }

    public static class_1792 getByBackpackMaterial(BackpackMaterial backpackMaterial) {
        class_2960 resourceLocation = class_2960.method_60655((String)"nemos_backpacks", (String)BackpackItem.getItemName(backpackMaterial));
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(resourceLocation);
        if (item == class_1802.field_8162) {
            throw new IllegalArgumentException("Missing item: " + String.valueOf(resourceLocation));
        }
        return item;
    }

    private static String getItemName(class_1767 color, BackpackMaterial backpackMaterial) {
        String materialPrefix = switch (backpackMaterial) {
            default -> throw new MatchException(null, null);
            case BackpackMaterial.STRING -> "";
            case BackpackMaterial.COPPER -> "copper";
            case BackpackMaterial.IRON -> "iron";
            case BackpackMaterial.GOLD -> "golden";
            case BackpackMaterial.DIAMOND -> "diamond";
            case BackpackMaterial.NETHERITE -> "netherite";
        };
        return color.method_7792() + (String)(!materialPrefix.isEmpty() ? "_" + materialPrefix : "") + "_backpack";
    }

    private static String getItemName(BackpackMaterial backpackMaterial) {
        String materialPrefix = switch (backpackMaterial) {
            default -> throw new MatchException(null, null);
            case BackpackMaterial.STRING -> "";
            case BackpackMaterial.COPPER -> "copper";
            case BackpackMaterial.IRON -> "iron";
            case BackpackMaterial.GOLD -> "golden";
            case BackpackMaterial.DIAMOND -> "diamond";
            case BackpackMaterial.NETHERITE -> "netherite";
        };
        return (String)(!materialPrefix.isEmpty() ? materialPrefix + "_" : "") + "backpack";
    }
}

