/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.backpacks.world.item;

import com.nemonotfound.nemos.backpacks.tags.BackpackItemTags;
import com.nemonotfound.nemos.backpacks.world.inventory.BackpackMenu;
import com.nemonotfound.nemos.backpacks.world.item.BackpackMaterial;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackItem
extends Item {
    private static final Component TITLE = Component.translatable((String)"nemos_backpacks.container.backpack");
    private final BackpackMaterial backpackMaterial;
    private final DyeColor dyeColor;

    public BackpackItem(Item.Properties properties, BackpackMaterial backpackMaterial, DyeColor dyeColor) {
        super(properties);
        this.backpackMaterial = backpackMaterial;
        this.dyeColor = dyeColor;
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack backpackItemStack = this.getBackpackItemStack(player, interactionHand);
        player.openMenu(this.createScreenHandlerFactory(backpackItemStack));
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResult.SUCCESS;
    }

    private ItemStack getBackpackItemStack(Player player, InteractionHand interactionHand) {
        if (interactionHand == null) {
            Inventory playerInventory = player.getInventory();
            return playerInventory.getItem(46);
        }
        return player.getItemInHand(interactionHand);
    }

    @Nullable
    public MenuProvider createScreenHandlerFactory(ItemStack itemStack) {
        DataComponentMap components = itemStack.getComponents();
        ItemContainerContents itemContainerContents = (ItemContainerContents)components.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        int slotCountPerRow = 9;
        SimpleContainer container = new SimpleContainer(slotCountPerRow * this.getRowCount());
        List items = itemContainerContents.stream().toList();
        for (int i = 0; i < items.size(); ++i) {
            container.setItem(i, (ItemStack)items.get(i));
        }
        return new SimpleMenuProvider((syncId, playerInventory, player1) -> switch (this.backpackMaterial) {
            default -> throw new MatchException(null, null);
            case BackpackMaterial.STRING -> {
                if (this.dyeColor == null) {
                    yield BackpackMenu.defaultBackpack(syncId, playerInventory, itemStack, (Container)container);
                }
                switch (this.dyeColor) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case WHITE: {
                        yield BackpackMenu.defaultWhiteBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIGHT_GRAY: {
                        yield BackpackMenu.defaultLightGrayBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case GRAY: {
                        yield BackpackMenu.defaultGrayBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BLACK: {
                        yield BackpackMenu.defaultBlackBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BROWN: {
                        yield BackpackMenu.defaultBrownBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case RED: {
                        yield BackpackMenu.defaultRedBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case ORANGE: {
                        yield BackpackMenu.defaultOrangeBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case YELLOW: {
                        yield BackpackMenu.defaultYellowBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIME: {
                        yield BackpackMenu.defaultLimeBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case GREEN: {
                        yield BackpackMenu.defaultGreenBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case CYAN: {
                        yield BackpackMenu.defaultCyanBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIGHT_BLUE: {
                        yield BackpackMenu.defaultLightBlueBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BLUE: {
                        yield BackpackMenu.defaultBlueBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case PURPLE: {
                        yield BackpackMenu.defaultPurpleBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case MAGENTA: {
                        yield BackpackMenu.defaultMagentaBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case PINK: 
                }
                yield BackpackMenu.defaultPinkBackpack(syncId, playerInventory, itemStack, (Container)container);
            }
            case BackpackMaterial.COPPER -> {
                if (this.dyeColor == null) {
                    yield BackpackMenu.copperBackpack(syncId, playerInventory, itemStack, (Container)container);
                }
                switch (this.dyeColor) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case WHITE: {
                        yield BackpackMenu.copperWhiteBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIGHT_GRAY: {
                        yield BackpackMenu.copperLightGrayBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case GRAY: {
                        yield BackpackMenu.copperGrayBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BLACK: {
                        yield BackpackMenu.copperBlackBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BROWN: {
                        yield BackpackMenu.copperBrownBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case RED: {
                        yield BackpackMenu.copperRedBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case ORANGE: {
                        yield BackpackMenu.copperOrangeBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case YELLOW: {
                        yield BackpackMenu.copperYellowBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIME: {
                        yield BackpackMenu.copperLimeBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case GREEN: {
                        yield BackpackMenu.copperGreenBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case CYAN: {
                        yield BackpackMenu.copperCyanBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIGHT_BLUE: {
                        yield BackpackMenu.copperLightBlueBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BLUE: {
                        yield BackpackMenu.copperBlueBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case PURPLE: {
                        yield BackpackMenu.copperPurpleBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case MAGENTA: {
                        yield BackpackMenu.copperMagentaBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case PINK: 
                }
                yield BackpackMenu.copperPinkBackpack(syncId, playerInventory, itemStack, (Container)container);
            }
            case BackpackMaterial.IRON -> {
                if (this.dyeColor == null) {
                    yield BackpackMenu.ironBackpack(syncId, playerInventory, itemStack, (Container)container);
                }
                switch (this.dyeColor) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case WHITE: {
                        yield BackpackMenu.ironWhiteBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIGHT_GRAY: {
                        yield BackpackMenu.ironLightGrayBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case GRAY: {
                        yield BackpackMenu.ironGrayBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BLACK: {
                        yield BackpackMenu.ironBlackBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BROWN: {
                        yield BackpackMenu.ironBrownBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case RED: {
                        yield BackpackMenu.ironRedBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case ORANGE: {
                        yield BackpackMenu.ironOrangeBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case YELLOW: {
                        yield BackpackMenu.ironYellowBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIME: {
                        yield BackpackMenu.ironLimeBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case GREEN: {
                        yield BackpackMenu.ironGreenBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case CYAN: {
                        yield BackpackMenu.ironCyanBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIGHT_BLUE: {
                        yield BackpackMenu.ironLightBlueBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BLUE: {
                        yield BackpackMenu.ironBlueBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case PURPLE: {
                        yield BackpackMenu.ironPurpleBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case MAGENTA: {
                        yield BackpackMenu.ironMagentaBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case PINK: 
                }
                yield BackpackMenu.ironPinkBackpack(syncId, playerInventory, itemStack, (Container)container);
            }
            case BackpackMaterial.GOLD -> {
                if (this.dyeColor == null) {
                    yield BackpackMenu.goldenBackpack(syncId, playerInventory, itemStack, (Container)container);
                }
                switch (this.dyeColor) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case WHITE: {
                        yield BackpackMenu.goldenWhiteBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIGHT_GRAY: {
                        yield BackpackMenu.goldenLightGrayBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case GRAY: {
                        yield BackpackMenu.goldenGrayBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BLACK: {
                        yield BackpackMenu.goldenBlackBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BROWN: {
                        yield BackpackMenu.goldenBrownBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case RED: {
                        yield BackpackMenu.goldenRedBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case ORANGE: {
                        yield BackpackMenu.goldenOrangeBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case YELLOW: {
                        yield BackpackMenu.goldenYellowBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIME: {
                        yield BackpackMenu.goldenLimeBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case GREEN: {
                        yield BackpackMenu.goldenGreenBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case CYAN: {
                        yield BackpackMenu.goldenCyanBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIGHT_BLUE: {
                        yield BackpackMenu.goldenLightBlueBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BLUE: {
                        yield BackpackMenu.goldenBlueBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case PURPLE: {
                        yield BackpackMenu.goldenPurpleBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case MAGENTA: {
                        yield BackpackMenu.goldenMagentaBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case PINK: 
                }
                yield BackpackMenu.goldenPinkBackpack(syncId, playerInventory, itemStack, (Container)container);
            }
            case BackpackMaterial.DIAMOND -> {
                if (this.dyeColor == null) {
                    yield BackpackMenu.diamondBackpack(syncId, playerInventory, itemStack, (Container)container);
                }
                switch (this.dyeColor) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case WHITE: {
                        yield BackpackMenu.diamondWhiteBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIGHT_GRAY: {
                        yield BackpackMenu.diamondLightGrayBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case GRAY: {
                        yield BackpackMenu.diamondGrayBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BLACK: {
                        yield BackpackMenu.diamondBlackBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BROWN: {
                        yield BackpackMenu.diamondBrownBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case RED: {
                        yield BackpackMenu.diamondRedBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case ORANGE: {
                        yield BackpackMenu.diamondOrangeBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case YELLOW: {
                        yield BackpackMenu.diamondYellowBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIME: {
                        yield BackpackMenu.diamondLimeBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case GREEN: {
                        yield BackpackMenu.diamondGreenBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case CYAN: {
                        yield BackpackMenu.diamondCyanBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIGHT_BLUE: {
                        yield BackpackMenu.diamondLightBlueBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BLUE: {
                        yield BackpackMenu.diamondBlueBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case PURPLE: {
                        yield BackpackMenu.diamondPurpleBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case MAGENTA: {
                        yield BackpackMenu.diamondMagentaBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case PINK: 
                }
                yield BackpackMenu.diamondPinkBackpack(syncId, playerInventory, itemStack, (Container)container);
            }
            case BackpackMaterial.NETHERITE -> {
                if (this.dyeColor == null) {
                    yield BackpackMenu.netheriteBackpack(syncId, playerInventory, itemStack, (Container)container);
                }
                switch (this.dyeColor) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case WHITE: {
                        yield BackpackMenu.netheriteWhiteBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIGHT_GRAY: {
                        yield BackpackMenu.netheriteLightGrayBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case GRAY: {
                        yield BackpackMenu.netheriteGrayBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BLACK: {
                        yield BackpackMenu.netheriteBlackBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BROWN: {
                        yield BackpackMenu.netheriteBrownBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case RED: {
                        yield BackpackMenu.netheriteRedBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case ORANGE: {
                        yield BackpackMenu.netheriteOrangeBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case YELLOW: {
                        yield BackpackMenu.netheriteYellowBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIME: {
                        yield BackpackMenu.netheriteLimeBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case GREEN: {
                        yield BackpackMenu.netheriteGreenBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case CYAN: {
                        yield BackpackMenu.netheriteCyanBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case LIGHT_BLUE: {
                        yield BackpackMenu.netheriteLightBlueBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case BLUE: {
                        yield BackpackMenu.netheriteBlueBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case PURPLE: {
                        yield BackpackMenu.netheritePurpleBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case MAGENTA: {
                        yield BackpackMenu.netheriteMagentaBackpack(syncId, playerInventory, itemStack, (Container)container);
                    }
                    case PINK: 
                }
                yield BackpackMenu.netheritePinkBackpack(syncId, playerInventory, itemStack, (Container)container);
            }
        }, TITLE);
    }

    public void onDestroyed(ItemEntity itemEntity) {
        ItemContainerContents itemContainerContents = (ItemContainerContents)this.components().getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        itemEntity.getItem().set(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, (Iterable)itemContainerContents.nonEmptyItemsCopy());
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack backpack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        return this.overrideStackingLogic(backpack, slot.getItem(), slot, false, action, player);
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack backpack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        return this.overrideStackingLogic(backpack, other, slot, true, action, player);
    }

    private boolean overrideStackingLogic(ItemStack backpack, ItemStack other, Slot slot, boolean isSlotModified, ClickAction action, Player player) {
        if (other.is(BackpackItemTags.BACKPACKS) || action != ClickAction.PRIMARY || other.isEmpty()) {
            return false;
        }
        ItemContainerContents itemContainerContents = (ItemContainerContents)backpack.get(DataComponents.CONTAINER);
        if (itemContainerContents == null) {
            return false;
        }
        SimpleContainer container = this.getContainer(itemContainerContents);
        if ((!isSlotModified || slot.allowModification(player)) && this.tryMoveItem(container, other)) {
            this.playInsertSound((Entity)player);
        } else {
            this.playInsertFailSound((Entity)player);
        }
        this.storeItemsIntoBackpack(container, backpack, player);
        return true;
    }

    private SimpleContainer getContainer(ItemContainerContents itemContainerContents) {
        int slotCountPerRow = 9;
        SimpleContainer container = new SimpleContainer(slotCountPerRow * this.getRowCount());
        List items = itemContainerContents.stream().toList();
        for (int i = 0; i < items.size(); ++i) {
            container.setItem(i, (ItemStack)items.get(i));
        }
        return container;
    }

    private boolean tryMoveItem(SimpleContainer container, ItemStack itemToMove) {
        boolean itemWasMoved;
        ItemStack remainingStack = container.addItem(itemToMove);
        boolean bl = itemWasMoved = remainingStack.isEmpty() || remainingStack.getCount() != itemToMove.getCount();
        if (!itemWasMoved) {
            return false;
        }
        itemToMove.setCount(remainingStack.getCount());
        return true;
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertFailSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT_FAIL, 1.0f, 1.0f);
    }

    private void storeItemsIntoBackpack(SimpleContainer container, ItemStack backpack, Player player) {
        ArrayList<ItemStack> containerItems = new ArrayList<ItemStack>();
        for (int i = 0; i < container.getContainerSize(); ++i) {
            containerItems.add(container.getItem(i));
        }
        backpack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(containerItems));
        this.broadcastChangesOnContainerMenu(player);
    }

    private void broadcastChangesOnContainerMenu(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        abstractContainerMenu.slotsChanged((Container)player.getInventory());
    }

    private int getRowCount() {
        return switch (this.backpackMaterial) {
            default -> throw new MatchException(null, null);
            case BackpackMaterial.STRING -> 1;
            case BackpackMaterial.COPPER -> 2;
            case BackpackMaterial.IRON -> 3;
            case BackpackMaterial.GOLD -> 4;
            case BackpackMaterial.DIAMOND -> 5;
            case BackpackMaterial.NETHERITE -> 6;
        };
    }

    public static Item getByColorAndBackpackMaterial(DyeColor color, BackpackMaterial backpackMaterial) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"nemos_backpacks", (String)BackpackItem.getItemName(color, backpackMaterial));
        Item item = (Item)BuiltInRegistries.ITEM.getValue(resourceLocation);
        if (item == Items.AIR) {
            throw new IllegalArgumentException("Missing item: " + String.valueOf(resourceLocation));
        }
        return item;
    }

    public static Item getByBackpackMaterial(BackpackMaterial backpackMaterial) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"nemos_backpacks", (String)BackpackItem.getItemName(backpackMaterial));
        Item item = (Item)BuiltInRegistries.ITEM.getValue(resourceLocation);
        if (item == Items.AIR) {
            throw new IllegalArgumentException("Missing item: " + String.valueOf(resourceLocation));
        }
        return item;
    }

    private static String getItemName(DyeColor color, BackpackMaterial backpackMaterial) {
        String materialPrefix = switch (backpackMaterial) {
            default -> throw new MatchException(null, null);
            case BackpackMaterial.STRING -> "";
            case BackpackMaterial.COPPER -> "copper";
            case BackpackMaterial.IRON -> "iron";
            case BackpackMaterial.GOLD -> "golden";
            case BackpackMaterial.DIAMOND -> "diamond";
            case BackpackMaterial.NETHERITE -> "netherite";
        };
        return color.getName() + (String)(!materialPrefix.isEmpty() ? "_" + materialPrefix : "") + "_backpack";
    }

    private static String getItemName(BackpackMaterial backpackMaterial) {
        String materialPrefix = switch (backpackMaterial) {
            default -> throw new MatchException(null, null);
            case BackpackMaterial.STRING -> "";
            case BackpackMaterial.COPPER -> "copper";
            case BackpackMaterial.IRON -> "iron";
            case BackpackMaterial.GOLD -> "golden";
            case BackpackMaterial.DIAMOND -> "diamond";
            case BackpackMaterial.NETHERITE -> "netherite";
        };
        return (String)(!materialPrefix.isEmpty() ? materialPrefix + "_" : "") + "backpack";
    }
}

