/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.backpacks.world.inventory;

import com.nemonotfound.nemos.backpacks.core.component.BackpacksDataComponents;
import com.nemonotfound.nemos.backpacks.helper.Backpacker;
import com.nemonotfound.nemos.backpacks.world.inventory.BackpackMenuTypes;
import com.nemonotfound.nemos.backpacks.world.inventory.BackpackSlot;
import com.nemonotfound.nemos.backpacks.world.item.BackpackItem;
import com.nemonotfound.nemos.backpacks.world.item.BackpackMaterial;
import java.util.ArrayList;
import net.minecraft.class_11565;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3917;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackMenu
extends class_1703 {
    private final class_1263 container;
    private final int containerRows;
    private final class_1799 itemStack;
    private final class_1661 playerInventory;

    public static BackpackMenu defaultBackpack(int containerId, class_1661 playerInventory) {
        return new BackpackMenu(BackpackMenuTypes.DEFAULT_BACKPACK.get(), containerId, playerInventory, 1);
    }

    public static BackpackMenu defaultBackpack(int containerId, class_1661 playerInventory, class_1799 itemStack, class_1263 container) {
        return new BackpackMenu(BackpackMenuTypes.DEFAULT_BACKPACK.get(), containerId, playerInventory, itemStack, container, 1);
    }

    public static BackpackMenu copperBackpack(int containerId, class_1661 playerInventory) {
        return new BackpackMenu(BackpackMenuTypes.COPPER_BACKPACK.get(), containerId, playerInventory, 2);
    }

    public static BackpackMenu copperBackpack(int containerId, class_1661 playerInventory, class_1799 itemStack, class_1263 container) {
        return new BackpackMenu(BackpackMenuTypes.COPPER_BACKPACK.get(), containerId, playerInventory, itemStack, container, 2);
    }

    public static BackpackMenu ironBackpack(int containerId, class_1661 playerInventory) {
        return new BackpackMenu(BackpackMenuTypes.IRON_BACKPACK.get(), containerId, playerInventory, 3);
    }

    public static BackpackMenu ironBackpack(int containerId, class_1661 playerInventory, class_1799 itemStack, class_1263 container) {
        return new BackpackMenu(BackpackMenuTypes.IRON_BACKPACK.get(), containerId, playerInventory, itemStack, container, 3);
    }

    public static BackpackMenu goldenBackpack(int containerId, class_1661 playerInventory) {
        return new BackpackMenu(BackpackMenuTypes.GOLDEN_BACKPACK.get(), containerId, playerInventory, 4);
    }

    public static BackpackMenu goldenBackpack(int containerId, class_1661 playerInventory, class_1799 itemStack, class_1263 container) {
        return new BackpackMenu(BackpackMenuTypes.GOLDEN_BACKPACK.get(), containerId, playerInventory, itemStack, container, 4);
    }

    public static BackpackMenu diamondBackpack(int containerId, class_1661 playerInventory) {
        return new BackpackMenu(BackpackMenuTypes.DIAMOND_BACKPACK.get(), containerId, playerInventory, 5);
    }

    public static BackpackMenu diamondBackpack(int containerId, class_1661 playerInventory, class_1799 itemStack, class_1263 container) {
        return new BackpackMenu(BackpackMenuTypes.DIAMOND_BACKPACK.get(), containerId, playerInventory, itemStack, container, 5);
    }

    public static BackpackMenu netheriteBackpack(int containerId, class_1661 playerInventory) {
        return new BackpackMenu(BackpackMenuTypes.NETHERITE_BACKPACK.get(), containerId, playerInventory, 6);
    }

    public static BackpackMenu netheriteBackpack(int containerId, class_1661 playerInventory, class_1799 itemStack, class_1263 container) {
        return new BackpackMenu(BackpackMenuTypes.NETHERITE_BACKPACK.get(), containerId, playerInventory, itemStack, container, 6);
    }

    private BackpackMenu(class_3917<?> menuType, int containerId, class_1661 playerInventory, int rows) {
        this(menuType, containerId, playerInventory, ((Backpacker)playerInventory.field_7546).nemosBackpacks$getLastOpenedBackpack(), (class_1263)new class_1277(9 * rows), rows);
    }

    public BackpackMenu(@Nullable class_3917<?> menuType, int containerId, class_1661 playerInventory, class_1799 itemStack, class_1263 container, int rows) {
        super(menuType, containerId);
        BackpackMenu.method_17359((class_1263)container, (int)(rows * 9));
        this.container = container;
        this.containerRows = rows;
        this.itemStack = itemStack;
        this.playerInventory = playerInventory;
        container.method_5435((class_11565)playerInventory.field_7546);
        int xOffset = 8;
        int yOffset = 18;
        int gapBetweenContainerAndInventory = 13;
        this.addBackpackGrid(container, xOffset, yOffset);
        int inventoryYOffset = yOffset + this.containerRows * yOffset + gapBetweenContainerAndInventory;
        this.method_61624((class_1263)playerInventory, xOffset, inventoryYOffset);
    }

    private void addBackpackGrid(class_1263 container, int xOffset, int yOffset) {
        for (int rowIndex = 0; rowIndex < this.containerRows; ++rowIndex) {
            for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
                this.method_7621(new BackpackSlot(container, slotIndex + rowIndex * 9, xOffset + slotIndex * yOffset, yOffset + rowIndex * yOffset));
            }
        }
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int index) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 slotItemStack = slot.method_7677();
            itemstack = slotItemStack.method_7972();
            if (index < this.container.method_5439() ? !this.method_7616(slotItemStack, this.container.method_5439(), this.field_7761.size(), true) : !this.method_7616(slotItemStack, 0, this.container.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (slotItemStack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        this.storeBackpackItems();
        return itemstack;
    }

    public boolean method_7597(@NotNull class_1657 player) {
        return this.container.method_5443(player);
    }

    public void method_7593(int slotId, int button, @NotNull class_1713 clickType, @NotNull class_1657 player) {
        if (clickType.equals((Object)class_1713.field_7796) || this.isItemBackpackInUse(slotId, clickType, button)) {
            return;
        }
        super.method_7593(slotId, button, clickType, player);
        this.storeBackpackItems();
    }

    private boolean isItemBackpackInUse(int slotId, class_1713 clickType, int button) {
        int containerSize = this.container.method_5439();
        if (slotId < containerSize) {
            return false;
        }
        int inventoryContainerSize = 27;
        int hotbarStartIndex = containerSize + inventoryContainerSize;
        int hotbarEndIndex = hotbarStartIndex + 9 - 1;
        boolean isSlotIdWithinHotbarBounds = slotId >= hotbarStartIndex && slotId <= hotbarEndIndex;
        int inventorySlotId = isSlotIdWithinHotbarBounds ? slotId - hotbarStartIndex : slotId - containerSize + 9;
        class_1799 item = this.playerInventory.method_5438(inventorySlotId);
        if (clickType.equals((Object)class_1713.field_7791)) {
            class_1799 itemToSwap = this.playerInventory.method_5438(button);
            return this.isBackpackOpen(itemToSwap) || this.isBackpackOpen(item);
        }
        return this.isBackpackOpen(item);
    }

    private boolean isBackpackOpen(class_1799 itemStack) {
        return Boolean.TRUE.equals(itemStack.method_58695(BackpacksDataComponents.IS_BACKPACK_OPEN.get(), (Object)false));
    }

    public void method_7595(@NotNull class_1657 player) {
        super.method_7595(player);
        this.storeBackpackItems();
        this.container.method_5432((class_11565)player);
        this.itemStack.method_57379(BackpacksDataComponents.IS_BACKPACK_OPEN.get(), (Object)false);
    }

    private void storeBackpackItems() {
        ArrayList<class_1799> containerItems = new ArrayList<class_1799>();
        for (int i = 0; i < this.container.method_5439(); ++i) {
            containerItems.add(this.container.method_5438(i));
        }
        this.itemStack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(containerItems));
    }

    public int getRowCount() {
        return this.containerRows;
    }

    public BackpackMaterial getBackpackMaterial() {
        class_1792 item = this.itemStack.method_7909();
        if (!(item instanceof BackpackItem)) {
            return null;
        }
        return ((BackpackItem)item).getBackpackMaterial();
    }

    public class_1767 getDyeColor() {
        class_1792 item = this.itemStack.method_7909();
        if (!(item instanceof BackpackItem)) {
            return null;
        }
        return ((BackpackItem)item).getDyeColor();
    }
}

