/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.backpacks.client.gui.screens.inventory;

import com.nemonotfound.nemos.backpacks.client.BackpackKeyMappings;
import com.nemonotfound.nemos.backpacks.world.inventory.BackpackMenu;
import com.nemonotfound.nemos.backpacks.world.item.BackpackMaterial;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;

public class BackpackScreen
extends AbstractContainerScreen<BackpackMenu> {
    private final ResourceLocation backpackBackground;
    private final ResourceLocation backpackOverlay;
    private final int containerRows;

    public BackpackScreen(BackpackMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.containerRows = menu.getRowCount();
        this.imageHeight = 114 + this.containerRows * 18;
        this.inventoryLabelY = this.imageHeight - 94;
        this.backpackOverlay = BackpackScreen.getOverlayTextureLocation(menu.getBackpackMaterial());
        this.backpackBackground = BackpackScreen.getBackgroundTextureLocation(menu.getDyeColor());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int leftPos = (this.width - this.imageWidth) / 2;
        int topPos = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(RenderType::guiTextured, this.backpackBackground, leftPos, topPos, 0.0f, 0.0f, this.imageWidth, this.containerRows * 18 + 17, 256, 256);
        guiGraphics.blit(RenderType::guiTextured, this.backpackBackground, leftPos, topPos + this.containerRows * 18 + 17, 0.0f, 126.0f, this.imageWidth, 96, 256, 256);
        guiGraphics.blit(RenderType::guiTextured, this.backpackOverlay, leftPos, topPos, 0.0f, 0.0f, this.imageWidth, this.containerRows * 18 + 17, 256, 256);
        guiGraphics.blit(RenderType::guiTextured, this.backpackOverlay, leftPos, topPos + this.containerRows * 18 + 17, 0.0f, 126.0f, this.imageWidth, 96, 256, 256);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (BackpackKeyMappings.INTERACT_BACKPACK.get().matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (BackpackKeyMappings.INTERACT_BACKPACK.get().matchesMouse(button)) {
            this.onClose();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private static ResourceLocation getBackgroundTextureLocation(DyeColor dyeColor) {
        String dyeColorString = "default";
        if (dyeColor != null) {
            dyeColorString = dyeColor.getName();
        }
        return ResourceLocation.fromNamespaceAndPath((String)"nemos_backpacks", (String)String.format("textures/gui/container/backpack/background/%s_backpack_background.png", dyeColorString));
    }

    private static ResourceLocation getOverlayTextureLocation(BackpackMaterial backpackMaterial) {
        String backpackMaterialName = "default";
        if (backpackMaterial != null) {
            backpackMaterialName = backpackMaterial.getName();
        }
        return ResourceLocation.fromNamespaceAndPath((String)"nemos_backpacks", (String)String.format("textures/gui/container/backpack/overlay/%s_backpack_overlay.png", backpackMaterialName));
    }
}

