/*
 * Decompiled with CFR 0.152.
 */
package com.redgrapefruit.justenoughgems;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.redgrapefruit.justenoughgems.init.JEGArmor;
import com.redgrapefruit.justenoughgems.init.JEGItems;
import com.redgrapefruit.justenoughgems.init.JEGOres;
import com.redgrapefruit.justenoughgems.init.JEGTools;
import com.redgrapefruit.justenoughgems.init.JEGWeapons;
import com.redgrapefruit.justenoughgems.util.ComparisonResult;
import com.redgrapefruit.justenoughgems.util.SemanticVersion;
import com.redgrapefruit.justenoughgems.util.Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/redgrapefruit/justenoughgems/JEG;", "Lnet/fabricmc/api/ModInitializer;", "", "version", "", "checkForUpdates", "(Ljava/lang/String;)V", "onInitialize", "()V", "<init>", "justenoughgems"})
public final class JEG
implements ModInitializer {
    @NotNull
    public static final JEG INSTANCE = new JEG();

    private JEG() {
    }

    public void onInitialize() {
        JEGItems.INSTANCE.initialize();
        JEGTools.INSTANCE.initialize();
        JEGWeapons.INSTANCE.initialize();
        JEGArmor.INSTANCE.initialize();
        JEGOres.INSTANCE.initialize();
        String version = ((ModContainer)FabricLoader.getInstance().getModContainer("jeg").get()).getMetadata().getVersion().getFriendlyString();
        Utils.getLogger().info("Loaded JustEnoughGems " + version + '.');
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
        this.checkForUpdates(version);
    }

    private final void checkForUpdates(String version) {
        if (Utils.internetConnected()) {
            String raw = Utils.download("https://api.github.com/repos/RedGrapefruit09/JustEnoughGems/tags");
            raw = "{\"tags\":" + raw + '}';
            JsonObject obj = (JsonObject)new Gson().fromJson(raw, JsonObject.class);
            String tag = obj.get("tags").getAsJsonArray().get(0).getAsJsonObject().get("name").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
            SemanticVersion expectedVersion = SemanticVersion.Companion.from(tag);
            SemanticVersion actualVersion = SemanticVersion.Companion.from(version);
            switch (WhenMappings.$EnumSwitchMapping$0[expectedVersion.compare(actualVersion).ordinal()]) {
                case 1: {
                    Utils.getLogger().info("Running an up-to-date version of JustEnoughGems!");
                    break;
                }
                case 2: {
                    Utils.getLogger().warn("Running an outdated version of JustEnoughGems! Please, update to version " + expectedVersion.formatToString() + '.');
                    break;
                }
                case 3: {
                    Utils.getLogger().warn("Running an unreleased version of JustEnoughGems! Latest released version is " + expectedVersion.formatToString() + ", downgrade to it if needed.");
                }
            }
        } else {
            Utils.getLogger().warn("Internet is unavailable. Cannot check for updates!");
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComparisonResult.values().length];
            nArray[ComparisonResult.EQUAL.ordinal()] = 1;
            nArray[ComparisonResult.BIGGER.ordinal()] = 2;
            nArray[ComparisonResult.LESS.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

