/*
 * Decompiled with CFR 0.152.
 */
package com.blorbilon.cobblemonopponents;

import com.blorbilon.cobblemonopponents.Config;
import com.blorbilon.cobblemonopponents.MedalBlock;
import com.blorbilon.cobblemonopponents.TrophyBlock;
import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="cobblemonopponents")
public class CobblemonOpponents {
    public static final String MODID = "cobblemonopponents";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"cobblemonopponents");
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"cobblemonopponents");
    public static final DeferredBlock<Block> SUN_MEDAL = CobblemonOpponents.registerBlock("sun_medal", () -> new MedalBlock(BlockBehaviour.Properties.of().noOcclusion().destroyTime(0.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> TORRENT_MEDAL = CobblemonOpponents.registerBlock("torrent_medal", () -> new MedalBlock(BlockBehaviour.Properties.of().noOcclusion().destroyTime(0.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> DUNE_MEDAL = CobblemonOpponents.registerBlock("dune_medal", () -> new MedalBlock(BlockBehaviour.Properties.of().noOcclusion().destroyTime(0.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> AVALANCHE_MEDAL = CobblemonOpponents.registerBlock("avalanche_medal", () -> new MedalBlock(BlockBehaviour.Properties.of().noOcclusion().destroyTime(0.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> CYNTHIA_TROPHY = CobblemonOpponents.registerBlock("cynthia_trophy", () -> new TrophyBlock(BlockBehaviour.Properties.of().destroyTime(0.5f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> N_TROPHY = CobblemonOpponents.registerBlock("n_trophy", () -> new TrophyBlock(BlockBehaviour.Properties.of().destroyTime(0.5f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> STEVEN_TROPHY = CobblemonOpponents.registerBlock("steven_trophy", () -> new TrophyBlock(BlockBehaviour.Properties.of().destroyTime(0.5f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> LANCE_TROPHY = CobblemonOpponents.registerBlock("lance_trophy", () -> new TrophyBlock(BlockBehaviour.Properties.of().destroyTime(0.5f).sound(SoundType.METAL)));
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"cobblemonopponents");
    public static final Supplier<SoundEvent> CYNTHIA = SOUND_EVENTS.register("battle.trainer.cynthia", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"battle.trainer.cynthia")));
    public static final Supplier<SoundEvent> LANCE = SOUND_EVENTS.register("battle.trainer.lance", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"battle.trainer.lance")));
    public static final Supplier<SoundEvent> N = SOUND_EVENTS.register("battle.trainer.n", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"battle.trainer.n")));
    public static final Supplier<SoundEvent> STEVEN = SOUND_EVENTS.register("battle.trainer.steven", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"battle.trainer.steven")));
    public static final Supplier<SoundEvent> POOL = SOUND_EVENTS.register("battle.trainer.pool", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"battle.trainer.pool")));

    public CobblemonOpponents(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        SOUND_EVENTS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCKS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        CobblemonOpponents.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

