/*
 * Decompiled with CFR 0.152.
 */
package com.blorbilon.cobblemonopponents;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MedalBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final MapCodec<MedalBlock> CODEC = MedalBlock.simpleCodec(MedalBlock::new);
    private static final VoxelShape NORTH_AABB = Block.box((double)5.0, (double)4.0, (double)14.0, (double)11.0, (double)12.0, (double)16.0);
    private static final VoxelShape SOUTH_AABB = Block.box((double)5.0, (double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)2.0);
    private static final VoxelShape WEST_AABB = Block.box((double)14.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0);
    private static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)4.0, (double)5.0, (double)2.0, (double)12.0, (double)11.0);

    public MedalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        for (Direction direction : context.getNearestLookingDirections()) {
            if (direction.getAxis() == Direction.Axis.Y) {
                return null;
            }
            BlockState blockstate = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACE, (Comparable)AttachFace.WALL)).setValue((Property)FACING, (Comparable)direction.getOpposite());
            if (!blockstate.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return blockstate;
        }
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FACE});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch (direction) {
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
        }
        throw new MatchException(null, null);
    }
}

