/*
 * Decompiled with CFR 0.152.
 */
package com.tuempresa.plugin;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Da\u00f1oHpExtra
implements Listener {
    private final JavaPlugin plugin;
    private final Map<String, Double> damageModifiers;
    private final Map<String, Double> healthModifiers;

    public Da\u00f1oHpExtra(JavaPlugin plugin) {
        this.plugin = plugin;
        this.damageModifiers = new HashMap<String, Double>();
        this.healthModifiers = new HashMap<String, Double>();
        this.cargarConfiguracion();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void cargarConfiguracion() {
        YamlConfiguration config;
        ConfigurationSection modifiersSection;
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        if ((modifiersSection = (config = YamlConfiguration.loadConfiguration((File)configFile)).getConfigurationSection("modifiers")) != null) {
            for (String key : modifiersSection.getKeys(false)) {
                String id = modifiersSection.getString(key + ".id");
                double dmgModifier = modifiersSection.getDouble(key + ".dmgmodifier", 1.0);
                double hpModifier = modifiersSection.getDouble(key + ".hpmodifier", 1.0);
                if (id != null) {
                    this.damageModifiers.put(id, dmgModifier);
                    this.healthModifiers.put(id, hpModifier);
                    continue;
                }
                Bukkit.getLogger().warning(ChatColor.RED + "No se encontr\u00f3 un ID v\u00e1lido en " + key);
            }
        } else {
            Bukkit.getLogger().warning(ChatColor.RED + "No se encontr\u00f3 la secci\u00f3n 'modifiers' en config.yml.");
        }
    }

    public void recargarConfiguracion() {
        this.damageModifiers.clear();
        this.healthModifiers.clear();
        this.cargarConfiguracion();
        Bukkit.getLogger().info(ChatColor.GREEN + "\u00a1La configuraci\u00f3n de modificadores se ha recargado correctamente!");
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        if (damager == null) {
            return;
        }
        String namespacedId = damager.getType().getKey().toString();
        if (this.damageModifiers.containsKey(namespacedId)) {
            double multiplier = this.damageModifiers.get(namespacedId);
            if (event.getEntity() instanceof LivingEntity) {
                double originalDamage = event.getDamage();
                double modifiedDamage = originalDamage * multiplier;
                event.setDamage(modifiedDamage);
            }
        }
        if (this.healthModifiers.containsKey(namespacedId) && damager instanceof LivingEntity) {
            double hpMultiplier = this.healthModifiers.get(namespacedId);
            LivingEntity livingDamager = (LivingEntity)damager;
            double originalHealth = livingDamager.getHealth();
            double maxHealth = livingDamager.getAttribute(Attribute.GENERIC_MAX_HEALTH).getDefaultValue();
            double modifiedHealth = Math.min(originalHealth * hpMultiplier, maxHealth);
            livingDamager.setHealth(modifiedHealth);
        }
    }
}

