/*
 * Decompiled with CFR 0.152.
 */
package com.tuempresa.plugin;

import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class InventarioAleatorio
implements Listener {
    private final JavaPlugin plugin;
    private boolean habilitado;

    public InventarioAleatorio(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.cargarConfiguracion();
    }

    public void cargarConfiguracion() {
        FileConfiguration config = this.plugin.getConfig();
        this.habilitado = config.getBoolean("inventario_aleatorio.habilitado", true);
    }

    @EventHandler
    public void onPhantomAttack(EntityDamageByEntityEvent event) {
        if (!this.habilitado) {
            return;
        }
        if (event.getDamager().getType() == EntityType.PHANTOM && event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            this.mezclarInventario(player);
            player.sendMessage(ChatColor.RED + "\u00a1Los phantoms han revuelto tu inventario!");
        }
    }

    private void mezclarInventario(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null) continue;
            items.add(item);
        }
        Collections.shuffle(items);
        player.getInventory().clear();
        for (int i = 0; i < items.size(); ++i) {
            player.getInventory().setItem(i, (ItemStack)items.get(i));
        }
    }
}

