/*
 * Decompiled with CFR 0.152.
 */
package com.tuempresa.plugin;

import com.tuempresa.plugin.ThreadsPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerSunburnTask
extends BukkitRunnable {
    private final ThreadsPlugin plugin;

    public PlayerSunburnTask(ThreadsPlugin plugin) {
        this.plugin = plugin;
    }

    public void run() {
        boolean sunburnEnabled = this.plugin.getConfig().getBoolean("sunburn_enabled", true);
        if (!sunburnEnabled) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.shouldBurn(player)) continue;
            player.setFireTicks(40);
        }
    }

    private boolean shouldBurn(Player player) {
        Location loc = player.getLocation();
        World world = loc.getWorld();
        if (world == null || world.getEnvironment() != World.Environment.NORMAL) {
            return false;
        }
        long time = world.getTime();
        if (time < 0L || time > 12000L) {
            return false;
        }
        if (loc.getBlock().getLightFromSky() < 15) {
            return false;
        }
        return !player.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE);
    }
}

