/*
 * Decompiled with CFR 0.152.
 */
package com.tuempresa.plugin;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Totem
implements Listener {
    public final NamespacedKey usosKey;

    public Totem(JavaPlugin plugin) {
        this.usosKey = new NamespacedKey((Plugin)plugin, "usos_totem");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onTotemUse(EntityResurrectEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        ItemStack totem = this.getTotemDivino(player);
        if (totem == null) {
            return;
        }
        int usosRestantes = this.getUsosRestantes(totem);
        if (usosRestantes <= 0) {
            return;
        }
        this.actualizarUsosTotem(totem, --usosRestantes);
        if (usosRestantes > 0) {
            player.sendMessage(ChatColor.GOLD + "\u00a1El T\u00f3tem Divino te ha salvado! Usos restantes: " + usosRestantes);
            this.devolverTotem(player, totem);
        } else {
            player.sendMessage(ChatColor.RED + "\u00a1El T\u00f3tem Divino se ha agotado!");
        }
        event.setCancelled(false);
    }

    @EventHandler
    public void onAnvilRename(PrepareAnvilEvent event) {
        String newName;
        AnvilInventory inventory = event.getInventory();
        ItemStack item = inventory.getItem(0);
        if (item != null && this.esTotemDivino(item) && (newName = event.getInventory().getRenameText()) != null && ChatColor.stripColor((String)newName).equals("T\u00f3tem Divino")) {
            event.setResult(null);
        }
    }

    private ItemStack getTotemDivino(Player player) {
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        if (this.esTotemDivino(mainHand)) {
            return mainHand;
        }
        ItemStack offHand = player.getInventory().getItemInOffHand();
        if (this.esTotemDivino(offHand)) {
            return offHand;
        }
        return null;
    }

    private boolean esTotemDivino(ItemStack item) {
        if (item == null || item.getType() != Material.TOTEM_OF_UNDYING) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasDisplayName() || !meta.hasLore()) {
            return false;
        }
        String displayName = ChatColor.stripColor((String)meta.getDisplayName());
        return "T\u00f3tem Divino".equals(displayName);
    }

    private int getUsosRestantes(ItemStack totem) {
        ItemMeta meta = totem.getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return 3;
        }
        List lore = meta.getLore();
        if (lore == null || lore.isEmpty()) {
            return 3;
        }
        String usosLore = ChatColor.stripColor((String)((String)lore.get(lore.size() - 1)));
        if (usosLore.startsWith("Usos restantes: ")) {
            try {
                return Integer.parseInt(usosLore.replace("Usos restantes: ", ""));
            }
            catch (NumberFormatException e) {
                return 3;
            }
        }
        return 3;
    }

    private void actualizarUsosTotem(ItemStack totem, int usosRestantes) {
        ItemMeta meta = totem.getItemMeta();
        if (meta == null) {
            return;
        }
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ChatColor.GRAY + "Usos restantes: " + usosRestantes);
        meta.setLore(lore);
        meta.setDisplayName(ChatColor.GOLD + "T\u00f3tem Divino");
        meta.addEnchant(Enchantment.DURABILITY, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        totem.setItemMeta(meta);
    }

    private void devolverTotem(Player player, ItemStack totem) {
        if (player.getInventory().getItemInMainHand().equals((Object)totem)) {
            player.getInventory().setItemInMainHand(totem);
        } else if (player.getInventory().getItemInOffHand().equals((Object)totem)) {
            player.getInventory().setItemInOffHand(totem);
        }
    }

    public ItemStack crearTotemDivino() {
        ItemStack totem = new ItemStack(Material.TOTEM_OF_UNDYING);
        this.actualizarUsosTotem(totem, 3);
        return totem;
    }
}

