/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.configuration.files;

import dev.jsinco.gringotts.shaded.okaeri.configs.OkaeriConfig;
import dev.jsinco.gringotts.shaded.okaeri.configs.annotation.Comment;
import dev.jsinco.malts.configuration.OkaeriFile;
import dev.jsinco.malts.configuration.OkaeriFileName;
import dev.jsinco.malts.enums.Driver;
import dev.jsinco.malts.enums.EconomyProvider;
import dev.jsinco.malts.enums.WarehouseMode;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;

@OkaeriFileName(value="config.yml")
public class Config
extends OkaeriFile {
    @Comment(value={"The language file to use for Malts.", "The file must be located in the 'translations' directory.", "If you would like to use a language file that is not provided by Malts,", "you will need to create it yourself and place it in the 'translations' directory."})
    private String language = "en_us";
    @Comment(value={"What subcommand should the base command default to?"})
    private String baseCommandBehavior = "vaults";
    @Comment(value={"Toggles debug messages."})
    private boolean verboseLogging = false;
    @Comment(value={"Quick return allows players to click outside of their", "vaults or warehouse to return to the main 'Your Vaults'", "gui."})
    private QuickReturn quickReturn = new QuickReturn();
    @Comment(value={"These are the Malts storage settings. All tables are prefixed", "with 'malts_' on both SQLite and MySQL to ensure uniqueness."})
    private Storage storage = new Storage();
    private Vaults vaults = new Vaults();
    private Warehouse warehouse = new Warehouse();
    private Economy economy = new Economy();

    public String language() {
        return this.language;
    }

    public String baseCommandBehavior() {
        return this.baseCommandBehavior;
    }

    public boolean verboseLogging() {
        return this.verboseLogging;
    }

    public QuickReturn quickReturn() {
        return this.quickReturn;
    }

    public Storage storage() {
        return this.storage;
    }

    public Vaults vaults() {
        return this.vaults;
    }

    public Warehouse warehouse() {
        return this.warehouse;
    }

    public Economy economy() {
        return this.economy;
    }

    public static class QuickReturn
    extends OkaeriConfig {
        @Comment(value={"Whether or not to enable the quick return feature."})
        private boolean enabled = true;
        @Comment(value={"https://jd.papermc.io/paper/1.21.9/org/bukkit/event/inventory/ClickType.html"})
        private ClickType clickType = ClickType.RIGHT;

        public boolean enabled() {
            return this.enabled;
        }

        public ClickType clickType() {
            return this.clickType;
        }
    }

    public static class Storage
    extends OkaeriConfig {
        @Comment(value={"How long Malts should keep cacheable objects in", "memory before saving them back to disk. The default value", "is fine for most servers."})
        private long defaultObjectCacheTime = 1200000L;
        @Comment(value={"The driver to use for storing data. Malts provides no", "methods for swapping storage drivers. If you would like to", "change storage methods, you will need to do so manually using", "SQL editors or phpMyAdmin for importing & exporting.", " ", "* Your available options are: SQLITE, MYSQL", "If you choose to use MYSQL as your storage method", "you must configure your connection details."})
        private Driver driver = Driver.SQLITE;
        @Comment(value={"The name of the database. When using SQLite, this becomes the file name."})
        private String database = "malts";
        private String host = "localhost";
        private int port = 3306;
        private String username = "root";
        private String password = "password";
        private String jdbcFlags = "?useSSL=false&verifyServerCertificate=false&useUnicode=true&characterEncoding=utf-8";

        public long defaultObjectCacheTime() {
            return this.defaultObjectCacheTime;
        }

        public Driver driver() {
            return this.driver;
        }

        public String database() {
            return this.database;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }

        public String jdbcFlags() {
            return this.jdbcFlags;
        }
    }

    public static class Vaults
    extends OkaeriConfig {
        @Comment(value={"This is the default title of all vaults for Malts.", "This does not prevent players from changing their vault", "names to whatever they want."})
        private String defaultName = "Vault #{id}";
        @Comment(value={"The default icon for all vaults. This does not prevent", "players from setting their own custom icon."})
        private Material defaultIcon = Material.CHEST;
        @Comment(value={"The size for all Malts vaults. This setting applies globally.", "If this setting is lowered and players already have vaults that fill up to 54 slots,", "Malts will dynamically increase the size of the inventory until the inventory's", "items have been lowered to the desired configured amount."})
        private int size = 54;
        @Comment(value={"The maximum amount of characters that can be", "used to rename a vault."})
        private int maxNameCharacters = 25;
        @Comment(value={"The maximum amount of players that can be trusted to a single vault", "(not including the owner of the vault). This setting does not apply to", "warehouses as warehouses have no concept of 'trusting' and can only be", "accessed by the owner and/or moderators who have elevated permissions."})
        private int trustCap = 3;
        @Comment(value={"The default amount of vaults players have.", "Players may have their vaults increased by using", "'malts.maxvaults.<amount>' permissions.", "Or, by using '/malts max vaults add <player> <amount>'."})
        private int defaultMaxVaults = 5;

        public String defaultName() {
            return this.defaultName;
        }

        public Material defaultIcon() {
            return this.defaultIcon;
        }

        public int size() {
            return this.size;
        }

        public int maxNameCharacters() {
            return this.maxNameCharacters;
        }

        public int trustCap() {
            return this.trustCap;
        }

        public int defaultMaxVaults() {
            return this.defaultMaxVaults;
        }
    }

    public static class Warehouse
    extends Vaults {
        @Comment(value={"Automatically blacklist items that have a stack <= 1."})
        private boolean blacklistSingleStackMaterials = true;
        @Comment(value={"Manually prevent items from being stored in warehouses.", "Supports regex."})
        private List<String> blacklistedMaterials = List.of();
        @Comment(value={"All enabled warehouse modes for Malts.", "To use a specific mode, a player must have the", "permission 'malts.warehouse.mode.<mode> (e.g. malts.warehouse.mode.auto_store)", " ", "* AUTO_STORE: If a player has a compartment for the item they are picking up", "it will automatically be placed into the player's warehouse", "* CLICK_TO_DEPOSIT: Players can shift click any container to deposit items from their warehouse.", "the items they're depositing depends on the material they are holding in their hand.", "* AUTO_REPLENISH: Automatically replenish blocks and consumables when they're running low with", "stock from the player's warehouse."})
        private List<WarehouseMode> enabledModes = List.of(WarehouseMode.AUTO_STORE, WarehouseMode.CLICK_TO_DEPOSIT, WarehouseMode.AUTO_REPLENISH);
        @Comment(value={"The default amount of warehouse stock players have.", "Players may have their stock increased by using", "'malts.maxstock.<amount>' permissions.", "Or, by using '/malts max stock add <player> <amount>'."})
        private int defaultMaxStock = 500;

        public List<Material> blacklistedMaterials() {
            Material[] materials = Material.values();
            List<Pattern> patterns = this.blacklistedMaterials.stream().map(Pattern::compile).toList();
            ArrayList<Material> blacklist = new ArrayList<Material>();
            for (Material material : materials) {
                if (!patterns.stream().anyMatch(pattern -> pattern.matcher(material.toString()).matches())) continue;
                blacklist.add(material);
            }
            return blacklist;
        }

        public boolean blacklistSingleStackMaterials() {
            return this.blacklistSingleStackMaterials;
        }

        public List<WarehouseMode> enabledModes() {
            return this.enabledModes;
        }

        public int defaultMaxStock() {
            return this.defaultMaxStock;
        }
    }

    public static class Economy
    extends OkaeriConfig {
        @Comment(value={"The economy provider to use for Malts transactions", "* Options: NONE, VAULT"})
        private EconomyProvider economyProvider = EconomyProvider.NONE;
        private Vaults vaults = new Vaults();

        public EconomyProvider economyProvider() {
            return this.economyProvider;
        }

        public Vaults vaults() {
            return this.vaults;
        }

        public static class Vaults
        extends OkaeriConfig {
            @Comment(value={"The amount of currency a player is charged", "to create a new vault. Bypass with 'malts.bypass.economy'", "* Requires 'economyProvider' to be set to a valid provider."})
            private double creationFee = 0.0;
            @Comment(value={"The amount of currency a player is charged", "to open a vault. Bypass with 'malts.bypass.economy'", "* Requires 'economyProvider' to be set to a valid provider."})
            private double accessFee = 0.0;

            public double creationFee() {
                return this.creationFee;
            }

            public double accessFee() {
                return this.accessFee;
            }
        }
    }
}

