/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.utility;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.files.GuiConfig;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Text;
import dev.jsinco.malts.utility.Util;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public final class ItemStacks {
    private static final GuiConfig.BorderItem cfg = ConfigManager.get(GuiConfig.class).borderItem();
    private static final UUID STATIC_UUID = UUID.fromString("ffd467ff-d884-4ace-8732-72e0d8e476f2");
    private static final Map<ItemStack, int[]> defaultItems = new HashMap<ItemStack, int[]>();
    private static final ItemStack BACK_BUTTON = ItemStacks.builder().material(Material.BARRIER).displayName("<red><b>Back").lore("<gray>Go back to the previous menu").colorIfAbsentLore((TextColor)NamedTextColor.GRAY).build();
    public static final ItemStack BORDER = ItemStacks.builder().displayName(cfg.name()).material(cfg.material()).lore(cfg.lore()).build();

    public static Inventory getBaseInv(InventoryHolder holder, int size, String title) {
        return ItemStacks.getBaseInv(holder, size, title, false);
    }

    public static Inventory getBaseInv(InventoryHolder holder, int size, String title, boolean backButton) {
        return ItemStacks.getBaseInv(holder, size, Text.mm(title), backButton);
    }

    public static Inventory getBaseInv(InventoryHolder holder, int size, Component title, boolean backButton) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)holder, (int)size, (Component)title);
        if (size < 18) {
            return inv;
        }
        HashMap<ItemStack, int[]> items = new HashMap<ItemStack, int[]>(defaultItems);
        if (backButton) {
            items.put(BACK_BUTTON, new int[]{49});
        }
        for (Map.Entry entry : items.entrySet()) {
            ItemStack item = (ItemStack)entry.getKey();
            int[] slots = (int[])entry.getValue();
            for (int i = 0; i < slots.length; ++i) {
                if (size == 54) {
                    inv.setItem(slots[i], item);
                    continue;
                }
                int factor = 54 - size;
                if (i < slots.length / 2) {
                    inv.setItem(slots[i], item);
                    continue;
                }
                inv.setItem(slots[i] - factor, item);
            }
        }
        return inv;
    }

    public static ItemStack borderItem(Material m) {
        return ItemStacks.builder().material(m).displayName("<black>").build();
    }

    public static ItemStackBuilder builder() {
        return new ItemStackBuilder();
    }

    private ItemStacks() {
    }

    static {
        defaultItems.put(ItemStacks.borderItem(Material.GREEN_STAINED_GLASS_PANE), new int[]{0, 8, 45, 53});
        defaultItems.put(ItemStacks.borderItem(Material.SHORT_GRASS), new int[]{1, 7, 46, 52});
        defaultItems.put(ItemStacks.borderItem(Material.FERN), new int[]{2, 6, 47, 51});
        defaultItems.put(ItemStacks.borderItem(Material.ROSE_BUSH), new int[]{3, 5, 48, 50});
        defaultItems.put(ItemStacks.borderItem(Material.RED_MUSHROOM), new int[]{4, 49});
    }

    public static class ItemStackBuilder {
        private Material material = Material.BARRIER;
        private int amount = 1;
        private TextColor colorIfAbsentDisplayName = NamedTextColor.AQUA;
        private TextColor colorIfAbsentLore = NamedTextColor.WHITE;
        private String displayName;
        private List<String> lore;
        private Map<Enchantment, Integer> enchantments;
        private ItemFlag[] itemFlags;
        private PlayerProfile playerProfile;
        private EditMeta editMeta;
        private String headOwner;
        private Couple<String, Object>[] replacements;

        public ItemStackBuilder material(Material material) {
            this.material = material;
            return this;
        }

        public ItemStackBuilder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public ItemStackBuilder colorIfAbsentDisplayName(TextColor color) {
            this.colorIfAbsentDisplayName = color;
            return this;
        }

        public ItemStackBuilder colorIfAbsentLore(TextColor color) {
            this.colorIfAbsentLore = color;
            return this;
        }

        public ItemStackBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ItemStackBuilder lore(String ... lore) {
            this.lore = Arrays.stream(lore).toList();
            return this;
        }

        public ItemStackBuilder lore(List<String> lore) {
            this.lore = lore;
            return this;
        }

        public ItemStackBuilder enchantments(Map<Enchantment, Integer> enchantments) {
            this.enchantments = enchantments;
            return this;
        }

        public ItemStackBuilder glint(boolean glint) {
            if (glint) {
                this.enchantments = Map.of(Enchantment.LURE, 1);
                if (this.itemFlags != null) {
                    this.itemFlags = Arrays.copyOf(this.itemFlags, this.itemFlags.length + 1);
                    this.itemFlags[this.itemFlags.length - 1] = ItemFlag.HIDE_ENCHANTS;
                } else {
                    this.itemFlags = new ItemFlag[]{ItemFlag.HIDE_ENCHANTS};
                }
            } else {
                this.enchantments = null;
            }
            return this;
        }

        public ItemStackBuilder itemFlags(ItemFlag ... itemFlags) {
            this.itemFlags = itemFlags;
            return this;
        }

        public ItemStackBuilder base64Head(String base64Head) {
            this.playerProfile = Bukkit.createProfile((UUID)STATIC_UUID);
            this.playerProfile.getProperties().add(new ProfileProperty("textures", base64Head));
            return this;
        }

        public ItemStackBuilder playerProfile(PlayerProfile playerProfile) {
            this.playerProfile = playerProfile;
            return this;
        }

        public ItemStackBuilder headOwner(String headOwner) {
            this.headOwner = headOwner;
            return this;
        }

        public ItemStackBuilder editMeta(EditMeta editMeta) {
            this.editMeta = editMeta;
            return this;
        }

        public ItemStackBuilder stringReplacements(Couple<String, Object> ... replacements) {
            this.replacements = replacements;
            return this;
        }

        public ItemStack build() {
            SkullMeta skullMeta;
            ItemStack itemStack = ItemStack.of((Material)this.material, (int)this.amount);
            ItemMeta meta = itemStack.getItemMeta();
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS});
            if (this.replacements != null) {
                this.displayName = Util.replace(this.displayName, this.replacements);
                this.lore = Util.replaceAll(this.lore, this.replacements);
                this.headOwner = Util.replace(this.headOwner, this.replacements);
            }
            if (this.displayName != null) {
                Component c = Text.mmNoItalic(this.displayName).colorIfAbsent(this.colorIfAbsentDisplayName);
                meta.displayName(c);
            }
            if (this.lore != null) {
                List<Component> l = Text.mmlNoItalic(this.lore).stream().map(it -> it.colorIfAbsent(this.colorIfAbsentLore)).toList();
                meta.lore(l);
            }
            if (this.enchantments != null) {
                this.enchantments.forEach((enchantment, level) -> meta.addEnchant(enchantment, level.intValue(), true));
            }
            if (this.itemFlags != null) {
                meta.addItemFlags(this.itemFlags);
            }
            if (this.playerProfile != null && meta instanceof SkullMeta) {
                skullMeta = (SkullMeta)meta;
                skullMeta.setPlayerProfile(this.playerProfile);
            }
            if (this.headOwner != null && meta instanceof SkullMeta) {
                skullMeta = (SkullMeta)meta;
                skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)this.headOwner));
            }
            if (this.editMeta != null) {
                this.editMeta.editMeta(meta);
            }
            itemStack.setItemMeta(meta);
            return itemStack;
        }

        @FunctionalInterface
        public static interface EditMeta {
            public void editMeta(ItemMeta var1);
        }
    }
}

