/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts;

import dev.jsinco.malts.commands.MaltsBaseCommand;
import dev.jsinco.malts.commands.VaultsBaseCommand;
import dev.jsinco.malts.commands.WarehouseBaseCommand;
import dev.jsinco.malts.events.ChatPromptInputListener;
import dev.jsinco.malts.events.GuiListener;
import dev.jsinco.malts.events.PlayerListener;
import dev.jsinco.malts.events.VaultListener;
import dev.jsinco.malts.events.WarehouseListener;
import dev.jsinco.malts.obj.MaltsInventory;
import dev.jsinco.malts.storage.DataSource;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Malts
extends JavaPlugin {
    private static Malts instance;
    private static boolean shutdown;

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        DataSource.createInstance();
        this.getServer().getPluginCommand("malts").setExecutor((CommandExecutor)new MaltsBaseCommand());
        this.getServer().getPluginCommand("vaults").setExecutor((CommandExecutor)new VaultsBaseCommand());
        this.getServer().getPluginCommand("warehouse").setExecutor((CommandExecutor)new WarehouseBaseCommand());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new VaultListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WarehouseListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GuiListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatPromptInputListener(), (Plugin)this);
    }

    public void onDisable() {
        shutdown = true;
        DataSource dataSource = DataSource.getInstance();
        for (Player player : this.getServer().getOnlinePlayers()) {
            Inventory inv = player.getOpenInventory().getTopInventory();
            if (!(inv.getHolder(false) instanceof MaltsInventory)) continue;
            player.closeInventory();
        }
        dataSource.close();
    }

    public static Malts getInstance() {
        return instance;
    }

    public static boolean isShutdown() {
        return shutdown;
    }
}

