/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.enums;

import dev.jsinco.malts.integration.EconomyIntegration;
import dev.jsinco.malts.integration.Integration;
import dev.jsinco.malts.integration.external.PlayerPointsIntegration;
import dev.jsinco.malts.integration.external.VaultIntegration;
import dev.jsinco.malts.registry.Registry;
import org.jetbrains.annotations.Nullable;

public enum EconomyProvider {
    NONE(registry -> null),
    VAULT(registry -> registry.get(VaultIntegration.class)),
    PLAYER_POINTS(registry -> registry.get(PlayerPointsIntegration.class));

    private final Provider provider;

    private EconomyProvider(Provider provider) {
        this.provider = provider;
    }

    @Nullable
    public EconomyIntegration getIntegration() {
        if (this.provider == null) {
            return null;
        }
        return this.provider.getIntegration(Registry.INTEGRATIONS);
    }

    private static interface Provider {
        @Nullable
        public EconomyIntegration getIntegration(Registry<Integration> var1);
    }
}

