/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.obj;

import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.files.GuiConfig;
import dev.jsinco.malts.obj.SnapshotVault;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.ItemStacks;
import dev.jsinco.malts.utility.Util;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class OtherPlayerSnapshotVault
extends SnapshotVault {
    private static final GuiConfig.VaultOtherGui.VaultItem cfg = ConfigManager.get(GuiConfig.class).vaultOtherGui().vaultItem();

    public OtherPlayerSnapshotVault(SnapshotVault snapshotVault) {
        super(snapshotVault.getOwner(), snapshotVault.getId(), snapshotVault.getCustomName(), snapshotVault.getIcon(), snapshotVault.getTrustedPlayers());
    }

    @Override
    public ItemStack itemStack() {
        return ItemStacks.builder().stringReplacements(Couple.of("{vaultName}", this.getCustomName()), Couple.of("{id}", this.getId())).displayName(cfg.name()).material(this.getIcon()).lore(cfg.lore()).build();
    }

    @Override
    public void onClick(InventoryClickEvent event, ItemStack clickedItem) {
        if (!Util.hasPersistentKey(clickedItem, this.key())) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.isLeftClick()) {
            this.lazyVault().thenAccept(vault -> vault.open(player));
        }
    }
}

