/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.obj;

import com.google.common.collect.ImmutableList;
import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.files.GuiConfig;
import dev.jsinco.malts.gui.EditVaultGui;
import dev.jsinco.malts.gui.item.AbstractGuiItem;
import dev.jsinco.malts.obj.MaltsPlayer;
import dev.jsinco.malts.obj.Vault;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.ItemStacks;
import dev.jsinco.malts.utility.Util;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SnapshotVault
implements AbstractGuiItem {
    private static final GuiConfig.YourVaultsGui.VaultItem cfg = ConfigManager.get(GuiConfig.class).yourVaultsGui().vaultItem();
    private final UUID owner;
    private final int id;
    private final String customName;
    private final Material icon;
    private final ImmutableList<UUID> trustedPlayers;
    @Nullable
    private Vault lazyVault;

    public SnapshotVault(UUID owner, int id, String customName, Material icon) {
        this(owner, id, customName, icon, (ImmutableList<UUID>)ImmutableList.of());
    }

    public SnapshotVault(UUID owner, int id, String customName, Material icon, ImmutableList<UUID> trustedPlayers) {
        this.owner = owner;
        this.id = id;
        this.customName = customName != null && !customName.isEmpty() ? customName : "Vault #" + id;
        this.icon = icon != null && icon.isItem() ? icon : Material.CHEST;
        this.trustedPlayers = trustedPlayers;
    }

    public SnapshotVault(UUID owner, int id, String customName, Material icon, String trustedPlayers) {
        this.owner = owner;
        this.id = id;
        this.customName = customName != null && !customName.isEmpty() ? customName : "Vault #" + id;
        this.icon = icon != null && icon.isItem() ? icon : Material.CHEST;
        List json = (List)Util.GSON.fromJson(trustedPlayers, Vault.LIST_UUID_TYPE_TOKEN);
        this.trustedPlayers = json != null ? ImmutableList.copyOf((Collection)json) : ImmutableList.of();
    }

    public CompletableFuture<Vault> toVault() {
        DataSource dataSource = DataSource.getInstance();
        return dataSource.getVault(this.owner, this.id);
    }

    public void toVaultWithEconomy(Player player, Consumer<Vault> consumer) {
        DataSource dataSource = DataSource.getInstance();
        dataSource.getVaultWithEconomy(player, this.id, consumer);
    }

    public boolean isTrusted(UUID uuid) {
        return this.trustedPlayers.contains((Object)uuid);
    }

    public boolean canAccess(Player player) {
        return player.getUniqueId() == this.owner || this.trustedPlayers.contains((Object)player.getUniqueId()) || player.hasPermission(Vault.BYPASS_OPEN_VAULT_PERM);
    }

    @Override
    public ItemStack itemStack() {
        return ItemStacks.builder().stringReplacements(Couple.of("{vaultName}", this.customName), Couple.of("{id}", this.id)).displayName(cfg.name()).material(this.icon).lore(cfg.lore()).build();
    }

    public CompletableFuture<Vault> lazyVault() {
        if (this.lazyVault == null) {
            return this.toVault().thenApply(vault -> {
                this.lazyVault = vault;
                return vault;
            });
        }
        return CompletableFuture.completedFuture(this.lazyVault);
    }

    public void lazyVaultWithEconomy(Player player, Consumer<Vault> consumer) {
        this.toVaultWithEconomy(player, consumer);
    }

    @Override
    public void onClick(InventoryClickEvent event, ItemStack clickedItem) {
        if (!Util.hasPersistentKey(clickedItem, this.key())) {
            return;
        }
        boolean isLeftClick = event.isLeftClick();
        Player player = (Player)event.getWhoClicked();
        this.lazyVaultWithEconomy(player, vault -> {
            if (isLeftClick) {
                vault.open(player);
            } else {
                MaltsPlayer maltsPlayer = DataSource.getInstance().cachedObject(player.getUniqueId(), MaltsPlayer.class);
                EditVaultGui editVaultGui = new EditVaultGui((Vault)vault, maltsPlayer, player);
                editVaultGui.open(player);
            }
        });
    }

    public UUID getOwner() {
        return this.owner;
    }

    public int getId() {
        return this.id;
    }

    public String getCustomName() {
        return this.customName;
    }

    public Material getIcon() {
        return this.icon;
    }

    public ImmutableList<UUID> getTrustedPlayers() {
        return this.trustedPlayers;
    }
}

