/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.commands.subcommands;

import com.google.common.base.Preconditions;
import dev.jsinco.malts.Malts;
import dev.jsinco.malts.commands.interfaces.SubCommand;
import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.files.Config;
import dev.jsinco.malts.obj.CachedObject;
import dev.jsinco.malts.obj.MaltsPlayer;
import dev.jsinco.malts.obj.Vault;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Util;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class EditVaultCommand
implements SubCommand {
    private static final List<String> ICON_MATERIAL_NAMES = Arrays.stream(Material.values()).filter(Material::isItem).map(material -> material.name().toLowerCase()).toList();

    @Override
    public boolean execute(Malts plugin, CommandSender sender, String label, List<String> args) {
        if (args.size() < 2) {
            return false;
        }
        Player player = (Player)sender;
        DataSource dataSource = DataSource.getInstance();
        int vaultId = Util.getInteger(args.getFirst(), -1);
        ArgOption option = Util.getEnum(args.get(1), ArgOption.class);
        List<String> newArgs = args.subList(2, args.size());
        if (vaultId <= 0 || option == null) {
            return false;
        }
        dataSource.getVaultWithEconomy(player, vaultId, vault -> {
            boolean result = option.getExecutor().handle(dataSource, player, (Vault)vault, newArgs);
            if (!result) {
                lng.entry(l -> l.command().base().invalidUsage(), (Audience)sender, new Couple[0]);
            }
        });
        return true;
    }

    @Override
    public List<String> tabComplete(Malts plugin, CommandSender sender, String label, List<String> args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        return switch (args.size()) {
            case 1 -> {
                DataSource dataSource = DataSource.getInstance();
                MaltsPlayer maltsPlayer = dataSource.cachedObject(player.getUniqueId(), MaltsPlayer.class);
                Preconditions.checkNotNull((Object)maltsPlayer, (Object)"MaltsPlayer should not be null for online player.");
                yield IntStream.rangeClosed(1, maltsPlayer.getCalculatedMaxVaults()).mapToObj(String::valueOf).collect(Collectors.toList());
            }
            case 2 -> Stream.of(ArgOption.values()).map(it -> it.toString().toLowerCase()).toList();
            case 3 -> {
                ArgOption option = Util.getEnum(args.get(1), ArgOption.class);
                int vaultId = Util.getInteger(args.get(0), 1);
                if (option == null) {
                    yield List.of();
                }
                yield option.getTabCompleter().handle(player, vaultId);
            }
            default -> List.of();
        };
    }

    @Override
    public String permission() {
        return "malts.command.editvault";
    }

    @Override
    public boolean playerOnly() {
        return true;
    }

    @Override
    public String name() {
        return "editvault";
    }

    private static enum ArgOption {
        NAME((dataSource, sender, vault, args) -> {
            if (args.isEmpty()) {
                return false;
            }
            String newName = String.join((CharSequence)" ", args);
            int maxLength = ConfigManager.get(Config.class).vaults().maxNameCharacters();
            if (vault.setCustomName(newName)) {
                SubCommand.lng.entry(l -> l.vaults().nameChanged(), (Audience)sender, Couple.of("{vaultName}", newName));
                dataSource.saveVault(vault);
            } else {
                SubCommand.lng.entry(l -> l.vaults().vaultNameTooLong(), (Audience)sender, Couple.of("{maxLength}", maxLength));
            }
            return true;
        }, (sender, vaultId) -> List.of()),
        ICON((dataSource, sender, vault, args) -> {
            if (args.isEmpty()) {
                return false;
            }
            Material material = Util.getEnum((String)args.getFirst(), Material.class);
            if (material == null || !material.isItem()) {
                return false;
            }
            if (!vault.setIcon(material)) {
                return false;
            }
            dataSource.saveVault(vault);
            SubCommand.lng.entry(l -> l.vaults().iconChanged(), (Audience)sender, Couple.of("{material}", Util.formatEnumerator(material)));
            return true;
        }, (sender, vaultId) -> ICON_MATERIAL_NAMES),
        TRUST((dataSource, sender, vault, args) -> {
            if (args.isEmpty()) {
                return false;
            }
            String name = (String)args.getFirst();
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)name);
            UUID playerUUID = offlinePlayer.getUniqueId();
            int trustListCap = ConfigManager.get(Config.class).vaults().trustCap();
            if (!offlinePlayer.hasPlayedBefore()) {
                SubCommand.lng.entry(l -> l.vaults().playerNeverOnServer(), (Audience)sender, Couple.of("{name}", name));
                return true;
            }
            if (vault.isTrusted(playerUUID)) {
                if (vault.removeTrusted(playerUUID)) {
                    SubCommand.lng.entry(l -> l.vaults().playerUntrusted(), (Audience)sender, Couple.of("{name}", name));
                } else {
                    SubCommand.lng.entry(l -> l.vaults().playerNotTrusted(), (Audience)sender, Couple.of("{name}", name));
                }
            } else if (vault.addTrusted(playerUUID)) {
                SubCommand.lng.entry(l -> l.vaults().playerTrusted(), (Audience)sender, Couple.of("{name}", name));
            } else {
                SubCommand.lng.entry(l -> l.vaults().trustListMaxed(), (Audience)sender, Couple.of("{trustedListSize}", trustListCap));
            }
            dataSource.saveVault(vault);
            return true;
        }, (sender, vaultId) -> {
            UUID playerUUID = sender.getUniqueId();
            DataSource dataSource = DataSource.getInstance();
            CachedTrustedNames cachedVaultNames = dataSource.cachedObject(playerUUID, CachedTrustedNames.class);
            if (cachedVaultNames == null) {
                CompletionStage future = dataSource.getVault(playerUUID, vaultId).thenApply(vault -> {
                    List<String> names = vault.getTrustedPlayers().stream().map(uuid -> {
                        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                        return offlinePlayer.getName();
                    }).filter(Objects::nonNull).toList();
                    return new CachedTrustedNames(playerUUID, names);
                });
                dataSource.cacheObject(future, 7000L).thenAccept(cached -> {});
                return List.of("...");
            }
            return cachedVaultNames.getTrustedNames();
        });

        private final Handler executor;
        private final TabCompleter tabCompleter;

        @Generated
        public Handler getExecutor() {
            return this.executor;
        }

        @Generated
        public TabCompleter getTabCompleter() {
            return this.tabCompleter;
        }

        @Generated
        private ArgOption(Handler executor, TabCompleter tabCompleter) {
            this.executor = executor;
            this.tabCompleter = tabCompleter;
        }

        private static interface Handler {
            public boolean handle(DataSource var1, Player var2, Vault var3, List<String> var4);
        }

        private static interface TabCompleter {
            public List<String> handle(Player var1, int var2);
        }
    }

    private static class CachedTrustedNames
    implements CachedObject {
        private final UUID owner;
        private final List<String> trustedNames;
        private Long expire;

        public CachedTrustedNames(UUID owner, List<String> trustedNames) {
            this.owner = owner;
            this.trustedNames = trustedNames;
        }

        @Override
        @NotNull
        public UUID getUuid() {
            return this.owner;
        }

        @Override
        @NotNull
        public CompletableFuture<Void> save(DataSource dataSource) {
            return CompletableFuture.completedFuture(null);
        }

        @Generated
        public List<String> getTrustedNames() {
            return this.trustedNames;
        }

        @Override
        @Generated
        public Long getExpire() {
            return this.expire;
        }

        @Override
        @Generated
        public void setExpire(Long expire) {
            this.expire = expire;
        }
    }
}

