/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.configuration;

import com.google.common.base.Preconditions;
import dev.jsinco.malts.Malts;
import dev.jsinco.malts.configuration.NullKeyMerger;
import dev.jsinco.malts.configuration.OkaeriFile;
import dev.jsinco.malts.configuration.OkaeriFileName;
import dev.jsinco.malts.configuration.serdes.IntPairTransformer;
import dev.jsinco.malts.registry.Registry;
import dev.jsinco.malts.registry.RegistryCrafter;
import dev.jsinco.malts.shaded.okaeri.configs.OkaeriConfig;
import dev.jsinco.malts.shaded.okaeri.configs.serdes.standard.StandardSerdes;
import dev.jsinco.malts.shaded.okaeri.configs.yaml.bukkit.YamlBukkitConfigurer;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.FileUtil;
import dev.jsinco.malts.utility.Text;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class ConfigManager
implements RegistryCrafter.Extension<OkaeriConfig> {
    public static final String TRANSLATIONS_FOLDER = "translations";

    @Override
    public <T extends OkaeriConfig> T craft(Class<?> clazz) {
        OkaeriFileName annotation = clazz.getAnnotation(OkaeriFileName.class);
        if (annotation == null) {
            throw new IllegalStateException("OkaeriFile must be annotated with @OkaeriFileName");
        }
        String fileName = annotation.dynamicFileName() ? this.dynamicFileName(annotation) : annotation.value();
        Preconditions.checkNotNull((Object)fileName, (Object)("Dynamic file name could not be resolved for " + clazz.getName()));
        Path bindFile = DataSource.DATA_FOLDER.resolve(fileName);
        Object config = dev.jsinco.malts.shaded.okaeri.configs.ConfigManager.create(clazz, it -> {
            it.withConfigurer(new YamlBukkitConfigurer(), new StandardSerdes());
            it.withRemoveOrphans(false);
            it.withBindFile(bindFile);
            it.withSerdesPack(serdes -> serdes.register(new IntPairTransformer()));
            it.saveDefaults();
            it.load(true);
        });
        if (annotation.dynamicFileName()) {
            NullKeyMerger.mergeWithInternalDefaults(config, bindFile);
        }
        return (T)config;
    }

    private String dynamicFileName(OkaeriFileName annotation) {
        OkaeriFile config = (OkaeriFile)this.craft((Class)annotation.dynamicFileNameHolder());
        String value = config.get(annotation.dynamicFileNameKey(), String.class);
        if (value != null) {
            return String.format(annotation.dynamicFileNameFormat(), value);
        }
        return null;
    }

    public static <T extends OkaeriFile> T get(Class<T> clazz) {
        return (T)Registry.CONFIGS.values().stream().filter(it -> it.getClass().equals(clazz)).map(it -> it).findFirst().orElseThrow(() -> new IllegalStateException("No config found for class " + clazz.getName()));
    }

    public static void createTranslationConfigs() {
        Path targetDir = DataSource.DATA_FOLDER.resolve(TRANSLATIONS_FOLDER);
        File[] internalLangs = FileUtil.listInternalFiles("/translations");
        try {
            if (!Files.exists(targetDir, new LinkOption[0])) {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
            for (File file : internalLangs) {
                Path targetFile = targetDir.resolve(file.getName());
                if (Files.exists(targetFile, new LinkOption[0])) continue;
                try (InputStream in = Malts.class.getResourceAsStream("/translations/" + file.getName());){
                    if (in == null) continue;
                    Files.copy(in, targetFile, StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        catch (IOException e) {
            Text.error("Failed to create translation config files", e);
        }
    }
}

