/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.gui;

import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Text;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class PaginatedGui {
    private final String name;
    private final Inventory base;
    private final List<Inventory> pages = new ArrayList<Inventory>();

    public PaginatedGui(String name, Inventory base, List<ItemStack> items, Couple<Integer, Integer> startEndSlots, List<Integer> ignoredSlots, boolean buildIfEmpty) {
        this.name = name;
        this.base = base;
        if (items.isEmpty() && !buildIfEmpty) {
            return;
        }
        Inventory currentPage = this.newPage();
        int currentItem = 0;
        int currentSlot = startEndSlots.getFirst();
        while (currentItem < items.size()) {
            if (!ignoredSlots.contains(currentSlot) && currentPage.getItem(currentSlot) == null) {
                currentPage.setItem(currentSlot, items.get(currentItem++));
            }
            if (currentSlot >= startEndSlots.getSecond()) {
                currentPage = this.newPage();
                currentSlot = startEndSlots.getFirst();
                continue;
            }
            ++currentSlot;
        }
    }

    private Inventory newPage() {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this.base.getHolder(), (int)this.base.getSize(), (Component)Text.mm(this.name));
        inventory.setContents(this.base.getContents());
        this.pages.add(inventory);
        return inventory;
    }

    public Inventory getPage(int page) {
        return this.pages.get(page);
    }

    public int indexOf(Inventory page) {
        return this.pages.indexOf(page);
    }

    @Nullable
    public Inventory getNext(Inventory page) {
        int index = this.pages.indexOf(page);
        return index == -1 || index + 1 >= this.pages.size() ? null : this.pages.get(index + 1);
    }

    @Nullable
    public Inventory getPrevious(Inventory page) {
        int index = this.pages.indexOf(page);
        return index <= 0 ? null : this.pages.get(index - 1);
    }

    public void insert(Inventory page, int index) {
        InventoryHolder holder = page.getHolder();
        InventoryHolder baseHolder = this.base.getHolder();
        if (holder == null || !holder.equals((Object)baseHolder)) {
            throw new IllegalArgumentException("Page and base inventory must be of the same type");
        }
        this.pages.add(index, page);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Inventory getBase() {
        return this.base;
    }

    @Generated
    public List<Inventory> getPages() {
        return this.pages;
    }

    public static class Builder {
        private String name = "Paginated GUI";
        private Inventory base;
        private List<ItemStack> items = Collections.emptyList();
        private Couple<Integer, Integer> startEndSlots = new Couple<Integer, Integer>(0, 0);
        private List<Integer> ignoredSlots = Collections.emptyList();
        private boolean buildIfEmpty = true;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder base(Inventory base) {
            this.base = base;
            return this;
        }

        public Builder items(List<ItemStack> items) {
            this.items = items;
            return this;
        }

        public Builder startEndSlots(int start, int end) {
            this.startEndSlots = new Couple<Integer, Integer>(start, end);
            return this;
        }

        public Builder ignoredSlots(Integer ... ignoredSlots) {
            this.ignoredSlots = Arrays.asList(ignoredSlots);
            return this;
        }

        public Builder ignoredSlots(List<Integer> ignoredSlots) {
            this.ignoredSlots = ignoredSlots;
            return this;
        }

        public Builder buildIfEmpty(boolean buildIfEmpty) {
            this.buildIfEmpty = buildIfEmpty;
            return this;
        }

        public PaginatedGui build() {
            return new PaginatedGui(this.name, this.base, this.items, this.startEndSlots, this.ignoredSlots, this.buildIfEmpty);
        }
    }
}

