/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.gui.item;

import dev.jsinco.malts.gui.item.AbstractGuiItem;
import dev.jsinco.malts.gui.item.GuiIndex;
import dev.jsinco.malts.gui.item.GuiItemStackBuilder;
import dev.jsinco.malts.utility.ItemStacks;
import dev.jsinco.malts.utility.Util;
import lombok.Generated;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class UncontainedGuiItem
extends AbstractGuiItem {
    private final GuiItemStackBuilder itemStack;
    private final UncontainedGuiItemAction action;
    private final GuiIndex index;

    public UncontainedGuiItem(GuiItemStackBuilder itemStack, UncontainedGuiItemAction action, @Nullable GuiIndex index) {
        this.itemStack = itemStack;
        this.action = action;
        this.index = index;
    }

    @Override
    public ItemStack itemStack() {
        return this.itemStack.create(ItemStacks.builder()).build();
    }

    @Override
    public void onClick(InventoryClickEvent event, ItemStack clickedItem) {
        boolean isClicked = Util.hasPersistentKey(clickedItem, this.key());
        this.action.onClick(event, this, isClicked);
    }

    @Override
    public Integer index() {
        if (this.index == null) {
            return null;
        }
        return this.index.getIndex();
    }

    @Generated
    public static UncontainedGuiItemBuilder builder() {
        return new UncontainedGuiItemBuilder();
    }

    @FunctionalInterface
    public static interface UncontainedGuiItemAction {
        public void onClick(InventoryClickEvent var1, UncontainedGuiItem var2, boolean var3);
    }

    @Generated
    public static class UncontainedGuiItemBuilder {
        @Generated
        private GuiItemStackBuilder itemStack;
        @Generated
        private UncontainedGuiItemAction action;
        @Generated
        private GuiIndex index;

        @Generated
        UncontainedGuiItemBuilder() {
        }

        @Generated
        public UncontainedGuiItemBuilder itemStack(GuiItemStackBuilder itemStack) {
            this.itemStack = itemStack;
            return this;
        }

        @Generated
        public UncontainedGuiItemBuilder action(UncontainedGuiItemAction action) {
            this.action = action;
            return this;
        }

        @Generated
        public UncontainedGuiItemBuilder index(GuiIndex index) {
            this.index = index;
            return this;
        }

        @Generated
        public UncontainedGuiItem build() {
            return new UncontainedGuiItem(this.itemStack, this.action, this.index);
        }

        @Generated
        public String toString() {
            return "UncontainedGuiItem.UncontainedGuiItemBuilder(itemStack=" + String.valueOf(this.itemStack) + ", action=" + String.valueOf(this.action) + ", index=" + String.valueOf(this.index) + ")";
        }
    }
}

