/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.obj;

import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.files.Config;
import dev.jsinco.malts.enums.QuickReturnClickType;
import dev.jsinco.malts.enums.WarehouseMode;
import dev.jsinco.malts.obj.CachedObject;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.Text;
import dev.jsinco.malts.utility.Util;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaltsPlayer
implements CachedObject {
    private static final String MAX_VAULTS_PERMISSION_PREFIX = "malts.maxvaults";
    private static final String MAX_WAREHOUSE_STOCK_PERMISSION_PREFIX = "malts.maxstock";
    private static final Config cfg = ConfigManager.get(Config.class);
    private Long expire;
    private final UUID uuid;
    private int maxVaults;
    private int maxWarehouseStock;
    private WarehouseMode warehouseMode;
    private QuickReturnClickType quickReturnClickType;

    public MaltsPlayer(UUID uuid) {
        this.uuid = uuid;
        this.maxVaults = 0;
        this.maxWarehouseStock = 0;
        this.warehouseMode = WarehouseMode.NONE;
        this.quickReturnClickType = cfg.quickReturn().defaultClickType();
    }

    public MaltsPlayer(@NotNull UUID uuid, int maxVaults, int maxWarehouseStock, WarehouseMode warehouseMode, QuickReturnClickType quickReturnClickType) {
        this.uuid = uuid;
        this.maxVaults = maxVaults;
        this.maxWarehouseStock = maxWarehouseStock;
        this.warehouseMode = warehouseMode == null ? WarehouseMode.NONE : warehouseMode;
        this.quickReturnClickType = quickReturnClickType == null ? cfg.quickReturn().defaultClickType() : quickReturnClickType;
    }

    @Nullable
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public OfflinePlayer offlinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid);
    }

    public String name() {
        return this.offlinePlayer().getName();
    }

    public int getCalculatedMaxVaults() {
        int maxByPermission = this.getMaxByPermission(MAX_VAULTS_PERMISSION_PREFIX);
        return Math.max(maxByPermission + this.maxVaults, cfg.vaults().defaultMaxVaults());
    }

    public int getCalculatedMaxWarehouseStock() {
        int maxByPermission = this.getMaxByPermission(MAX_WAREHOUSE_STOCK_PERMISSION_PREFIX);
        return Math.max(maxByPermission + this.maxWarehouseStock, cfg.warehouse().defaultMaxStock());
    }

    private int getMaxByPermission(String permissionPrefix) {
        Player player = this.getPlayer();
        if (player == null) {
            return 0;
        }
        Pattern maxPermPattern = Pattern.compile(permissionPrefix + "\\.(\\d+)");
        return player.getEffectivePermissions().stream().map(permission -> {
            Matcher matcher = maxPermPattern.matcher(permission.getPermission());
            if (matcher.matches()) {
                int amt = Util.getInteger(matcher.group(1), -1);
                if (amt < 0) {
                    Text.warn("Invalid permission format for player " + player.getName() + ": " + permission.getPermission());
                }
                return amt;
            }
            return 0;
        }).max(Integer::compareTo).orElse(0);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> save(DataSource dataSource) {
        return dataSource.saveMaltsPlayer(this);
    }

    @Override
    public boolean isExpired() {
        return CachedObject.super.isExpired() && this.getPlayer() == null;
    }

    public String toString() {
        return "MaltsPlayer{uuid=" + String.valueOf(this.uuid) + ", expire=" + this.expire + ", maxVaults=" + this.maxVaults + ", maxWarehouseStock=" + this.maxWarehouseStock + "}";
    }

    @Override
    @Generated
    public Long getExpire() {
        return this.expire;
    }

    @Override
    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public int getMaxVaults() {
        return this.maxVaults;
    }

    @Generated
    public int getMaxWarehouseStock() {
        return this.maxWarehouseStock;
    }

    @Generated
    public WarehouseMode getWarehouseMode() {
        return this.warehouseMode;
    }

    @Generated
    public QuickReturnClickType getQuickReturnClickType() {
        return this.quickReturnClickType;
    }

    @Override
    @Generated
    public void setExpire(Long expire) {
        this.expire = expire;
    }

    @Generated
    public void setMaxVaults(int maxVaults) {
        this.maxVaults = maxVaults;
    }

    @Generated
    public void setMaxWarehouseStock(int maxWarehouseStock) {
        this.maxWarehouseStock = maxWarehouseStock;
    }

    @Generated
    public void setWarehouseMode(WarehouseMode warehouseMode) {
        this.warehouseMode = warehouseMode;
    }

    @Generated
    public void setQuickReturnClickType(QuickReturnClickType quickReturnClickType) {
        this.quickReturnClickType = quickReturnClickType;
    }
}

