/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.obj;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dev.jsinco.malts.api.events.interfaces.EventAction;
import dev.jsinco.malts.api.events.vault.VaultIconChangeEvent;
import dev.jsinco.malts.api.events.vault.VaultNameChangeEvent;
import dev.jsinco.malts.api.events.vault.VaultOpenEvent;
import dev.jsinco.malts.api.events.vault.VaultTrustPlayerEvent;
import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.files.Config;
import dev.jsinco.malts.configuration.files.Lang;
import dev.jsinco.malts.obj.MaltsInventory;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Executors;
import dev.jsinco.malts.utility.Text;
import dev.jsinco.malts.utility.Util;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Vault
implements MaltsInventory {
    public static final Type LIST_UUID_TYPE_TOKEN = new TypeToken<List<UUID>>(){}.getType();
    public static String BYPASS_OPEN_VAULT_PERM = "malts.bypass.openvault";
    private static final Gson GSON = Util.GSON;
    private static final Config cfg = ConfigManager.get(Config.class);
    private final UUID owner;
    private final int id;
    private final Inventory inventory;
    @NotNull
    private String customName;
    @NotNull
    private Material icon;
    private List<UUID> trustedPlayers;

    public Vault(UUID owner, int id) {
        Preconditions.checkArgument((id > 0 ? 1 : 0) != 0, (Object)"Vault ID must be greater than 0");
        this.owner = owner;
        this.id = id;
        this.customName = cfg.vaults().defaultName().replace("{id}", String.valueOf(id));
        this.icon = cfg.vaults().defaultIcon();
        this.trustedPlayers = new ArrayList<UUID>();
        int size = cfg.vaults().size();
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (Component)Text.mm(this.customName));
    }

    public Vault(UUID owner, int id, ItemStack[] items) {
        Preconditions.checkArgument((id > 0 ? 1 : 0) != 0, (Object)"Vault ID must be greater than 0");
        this.owner = owner;
        this.id = id;
        this.customName = cfg.vaults().defaultName().replace("{id}", String.valueOf(id));
        this.icon = cfg.vaults().defaultIcon();
        this.trustedPlayers = new ArrayList<UUID>();
        int count = items != null ? items.length : 9;
        int size = Math.max((count + 8) / 9 * 9, cfg.vaults().size());
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (Component)Text.mm(this.customName));
        if (items != null) {
            this.inventory.setContents(items);
        }
    }

    public Vault(UUID owner, int id, String encodedInventory, String customName, Material icon, String trustedPlayers) {
        this.owner = owner;
        this.id = id;
        this.customName = customName != null && !customName.isEmpty() ? customName : "Vault #" + id;
        this.icon = icon != null && icon.isItem() ? icon : cfg.vaults().defaultIcon();
        List json = (List)GSON.fromJson(trustedPlayers, LIST_UUID_TYPE_TOKEN);
        this.trustedPlayers = json != null ? json : new ArrayList();
        ItemStack[] items = null;
        if (encodedInventory != null && !encodedInventory.isEmpty()) {
            items = Vault.decodeInventory(encodedInventory);
        }
        int count = items != null ? items.length : 9;
        int size = Math.max((count + 8) / 9 * 9, cfg.vaults().size());
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (Component)Text.mm(customName));
        if (items != null) {
            this.inventory.setContents(items);
        }
    }

    public String encodeInventory() {
        byte[] itemByteArray = ItemStack.serializeItemsAsBytes((ItemStack[])this.inventory.getContents());
        return Base64.getEncoder().encodeToString(itemByteArray);
    }

    public String encodeTrusted() {
        return GSON.toJson(this.trustedPlayers, LIST_UUID_TYPE_TOKEN);
    }

    public void open(Player player) {
        Executors.runSync(() -> {
            InventoryHolder patt0$temp;
            Couple<VaultOpenState, Player> couple = this.getOpenState();
            VaultOpenEvent event = new VaultOpenEvent(this, player, couple, !Bukkit.isPrimaryThread());
            event.setCancelled(couple.a() == VaultOpenState.OPEN);
            if (!event.callEvent()) {
                ConfigManager.get(Lang.class).entry(l -> l.vaults().alreadyOpen(), (Audience)player, new Couple[0]);
                return;
            }
            Couple<VaultOpenState, Player> updatedCouple = event.getOpenState();
            VaultOpenState state = updatedCouple.a();
            Player otherPlayer = updatedCouple.b();
            player.openInventory(this.inventory);
            if (state == VaultOpenState.BYPASSED && (patt0$temp = otherPlayer.getOpenInventory().getTopInventory().getHolder(false)) instanceof Vault) {
                Vault otherVault = (Vault)patt0$temp;
                otherVault.update(otherPlayer);
            }
        });
    }

    public Couple<@NotNull VaultOpenState, @Nullable Player> getOpenState() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.equals(player.getOpenInventory().getTopInventory().getHolder(false))) continue;
            if (player.hasPermission(BYPASS_OPEN_VAULT_PERM)) {
                return Couple.of(VaultOpenState.BYPASSED, player);
            }
            return Couple.of(VaultOpenState.OPEN, player);
        }
        return Couple.of(VaultOpenState.CLOSED, null);
    }

    public void update(@Nullable Player updater) {
        Executors.delayedSync(1L, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Inventory inv;
                if (updater != null && player.getUniqueId() == updater.getUniqueId() || !this.equals((inv = player.getOpenInventory().getTopInventory()).getHolder(false))) continue;
                inv.setContents(this.inventory.getContents());
                Text.debug("Updated inventory for player " + player.getName() + " with vault " + this.id);
            }
        });
    }

    public boolean canAccess(Player player) {
        return player.getUniqueId() == this.owner || this.trustedPlayers.contains(player.getUniqueId()) || player.hasPermission(BYPASS_OPEN_VAULT_PERM);
    }

    public boolean isTrusted(UUID uuid) {
        return this.trustedPlayers.contains(uuid) || uuid == this.owner;
    }

    public boolean addTrusted(UUID uuid) {
        int cap = cfg.vaults().trustCap();
        VaultTrustPlayerEvent event = new VaultTrustPlayerEvent(this, EventAction.ADD, uuid, !Bukkit.isPrimaryThread());
        event.setCancelled(this.trustedPlayers.size() >= cap);
        if (!event.callEvent()) {
            return false;
        }
        this.trustedPlayers.add(event.getTrustedUUID());
        return true;
    }

    public boolean removeTrusted(UUID uuid) {
        if (!this.trustedPlayers.contains(uuid)) {
            return false;
        }
        VaultTrustPlayerEvent event = new VaultTrustPlayerEvent(this, EventAction.REMOVE, uuid, !Bukkit.isPrimaryThread());
        if (!event.callEvent()) {
            return false;
        }
        this.trustedPlayers.remove(event.getTrustedUUID());
        return true;
    }

    public boolean setCustomName(@NotNull String customName) {
        int maxLength = cfg.vaults().maxNameCharacters();
        VaultNameChangeEvent event = new VaultNameChangeEvent(this, customName, !Bukkit.isPrimaryThread());
        event.setCancelled(customName.length() > maxLength);
        if (!event.callEvent()) {
            return false;
        }
        customName = event.getNewName();
        if (customName.length() > maxLength) {
            return false;
        }
        this.customName = customName;
        return true;
    }

    public boolean setIcon(@NotNull Material icon) {
        VaultIconChangeEvent event = new VaultIconChangeEvent(this, icon, !Bukkit.isPrimaryThread());
        if (!event.callEvent()) {
            return false;
        }
        this.icon = event.getNewIcon();
        return true;
    }

    public Vault copy(UUID newOwner) {
        Vault copy = new Vault(newOwner, this.id);
        copy.setCustomName(this.customName);
        copy.setIcon(this.icon);
        copy.setTrustedPlayers(new ArrayList<UUID>(this.trustedPlayers));
        copy.getInventory().setContents(this.getInventory().getContents());
        return copy;
    }

    private static ItemStack[] decodeInventory(String encodedInventory) {
        byte[] itemByteArray = Base64.getDecoder().decode(encodedInventory);
        return ItemStack.deserializeItemsFromBytes((byte[])itemByteArray);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vault vault = (Vault)o;
        return this.id == vault.id && Objects.equals(this.owner, vault.owner);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.id);
    }

    @Generated
    public UUID getOwner() {
        return this.owner;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public Inventory getInventory() {
        return this.inventory;
    }

    @NotNull
    @Generated
    public String getCustomName() {
        return this.customName;
    }

    @NotNull
    @Generated
    public Material getIcon() {
        return this.icon;
    }

    @Generated
    public List<UUID> getTrustedPlayers() {
        return this.trustedPlayers;
    }

    @Generated
    public void setTrustedPlayers(List<UUID> trustedPlayers) {
        this.trustedPlayers = trustedPlayers;
    }

    public static enum VaultOpenState {
        OPEN,
        BYPASSED,
        CLOSED;

    }
}

