/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.storage;

import com.google.common.base.Preconditions;
import dev.jsinco.malts.Malts;
import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.files.Config;
import dev.jsinco.malts.configuration.files.Lang;
import dev.jsinco.malts.enums.QuickReturnClickType;
import dev.jsinco.malts.enums.TriState;
import dev.jsinco.malts.enums.WarehouseMode;
import dev.jsinco.malts.integration.EconomyIntegration;
import dev.jsinco.malts.obj.CachedObject;
import dev.jsinco.malts.obj.MaltsPlayer;
import dev.jsinco.malts.obj.SnapshotVault;
import dev.jsinco.malts.obj.Stock;
import dev.jsinco.malts.obj.Vault;
import dev.jsinco.malts.obj.Warehouse;
import dev.jsinco.malts.shaded.hikari.HikariConfig;
import dev.jsinco.malts.shaded.hikari.HikariDataSource;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Executors;
import dev.jsinco.malts.utility.FileUtil;
import dev.jsinco.malts.utility.Text;
import dev.jsinco.malts.utility.Util;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataSource {
    public static final Path DATA_FOLDER = Malts.getInstance().getDataPath();
    private static final int SAVE_INTERVAL_SECONDS = 60;
    private static final int TASK_INTERVAL_SECONDS = 2;
    private static DataSource instance;
    protected final ExecutorService singleThread = Executors.newSingleThreadExecutor();
    private final ConcurrentLinkedQueue<CachedObject> cachedObjects = new ConcurrentLinkedQueue();
    private final HikariDataSource hikari;
    private ScheduledTask cacheTask;

    public abstract HikariConfig hikariConfig(Config.Storage var1);

    public abstract CompletableFuture<Void> createTables();

    public abstract CompletableFuture<@Nullable Vault> getVault(UUID var1, int var2, boolean var3);

    public abstract CompletableFuture<@Nullable Vault> getVault(UUID var1, String var2);

    public abstract CompletableFuture<@NotNull Collection<SnapshotVault>> getVaults(UUID var1);

    public abstract CompletableFuture<Void> saveVault(Vault var1);

    public abstract CompletableFuture<@NotNull Boolean> deleteVault(UUID var1, int var2);

    public abstract CompletableFuture<@NotNull Integer> deleteVaults(UUID var1);

    public abstract CompletableFuture<@NotNull Collection<Vault>> getAllVaults();

    public abstract CompletableFuture<@NotNull List<String>> getVaultNames(UUID var1);

    public abstract CompletableFuture<@NotNull Warehouse> getWarehouse(UUID var1);

    public abstract CompletableFuture<Void> saveWarehouse(Warehouse var1);

    public abstract CompletableFuture<@NotNull MaltsPlayer> getMaltsPlayer(UUID var1);

    public abstract CompletableFuture<Void> saveMaltsPlayer(MaltsPlayer var1);

    public abstract CompletableFuture<Integer> getTotalVaultCount();

    public abstract CompletableFuture<Integer> getTotalWarehouseStockCount();

    public CompletableFuture<@NotNull Vault> getVault(UUID owner, int id) {
        return this.getVault(owner, id, true);
    }

    public void getVaultWithEconomy(Player player, int id, Consumer<@NotNull Vault> consumer) {
        Config.Economy economy = ConfigManager.get(Config.class).economy();
        Lang lang = ConfigManager.get(Lang.class);
        @Nullable EconomyIntegration econ = economy.economyProvider().getIntegration();
        double creationFee = economy.vaults().creationFee();
        double accessFee = economy.vaults().accessFee();
        UUID owner = player.getUniqueId();
        this.getVault(owner, id, false).thenAccept(vault -> {
            if (vault == null) {
                if (econ != null && !econ.withdrawOrBypass(player, creationFee)) {
                    lang.entry(l -> l.economy().vaults().cannotAffordCreation(), (Audience)player, Couple.of("{cost}", String.format("%,.2f", creationFee)));
                    return;
                }
                vault = new Vault(owner, id);
                if (econ != null) {
                    lang.entry(l -> l.economy().vaults().created(), (Audience)player, Couple.of("{cost}", String.format("%,.2f", creationFee)));
                }
            } else if (econ != null) {
                if (!econ.withdrawOrBypass(player, accessFee)) {
                    lang.entry(l -> l.economy().vaults().cannotAffordAccess(), (Audience)player, Couple.of("{cost}", String.format("%,.2f", accessFee)));
                    return;
                }
                lang.entry(l -> l.economy().vaults().accessed(), (Audience)player, Couple.of("{cost}", String.format("%,.2f", accessFee)));
            }
            consumer.accept((Vault)vault);
        });
    }

    public DataSource(Config.Storage config) {
        this.hikari = new HikariDataSource(this.hikariConfig(config));
    }

    public Connection connection() throws SQLException {
        return this.hikari.getConnection();
    }

    public CompletableFuture<Void> setup() {
        AtomicInteger count = new AtomicInteger(0);
        return this.createTables().thenRun(() -> {
            this.cacheTask = Executors.runRepeatingAsync(2L, TimeUnit.SECONDS, task -> {
                int intervalCount = count.getAndAdd(2);
                for (CachedObject cachedObject : this.cachedObjects) {
                    if (intervalCount >= 60) {
                        Text.debug("Cached Objects size: " + this.cachedObjects.size());
                        Text.debug("Saved CachedObject " + cachedObject.getClass().getSimpleName() + ": " + String.valueOf(cachedObject.getUuid()));
                        cachedObject.save(this);
                    }
                    if (!cachedObject.isExpired()) continue;
                    cachedObject.save(this);
                    this.cachedObjects.remove(cachedObject);
                    Text.debug("Uncached " + cachedObject.getClass().getSimpleName() + ": " + String.valueOf(cachedObject.getUuid()) + " because it was expired");
                }
                if (intervalCount >= 60) {
                    count.set(0);
                }
            });
        });
    }

    public String[] getStatements(String path) {
        String[] statements = FileUtil.readInternalResource("sql/" + path).split(";");
        for (int i = 0; i < statements.length; ++i) {
            statements[i] = statements[i].trim() + ";";
        }
        return statements;
    }

    public String getStatement(String path) {
        return FileUtil.readInternalResource("sql/" + path);
    }

    public CompletableFuture<Void> clearCache() {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (CachedObject cachedObject : this.cachedObjects) {
            futures.add(cachedObject.save(this));
        }
        this.cachedObjects.clear();
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public CompletableFuture<Void> close() {
        return ((CompletableFuture)this.clearCache().exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        })).thenRun(() -> {
            this.cacheTask.cancel();
            this.hikari.close();
            this.singleThread.shutdown();
        });
    }

    public TriState isClosed() {
        boolean hikariClosed = this.hikari.isClosed();
        boolean singleThreadClosed = this.singleThread.isShutdown();
        boolean cacheTaskClosed = this.cacheTask.isCancelled();
        if (hikariClosed && singleThreadClosed && cacheTaskClosed) {
            return TriState.TRUE;
        }
        if (hikariClosed || singleThreadClosed || cacheTaskClosed) {
            return TriState.ALTERNATIVE_STATE;
        }
        return TriState.FALSE;
    }

    @Nullable
    public Vault mapVault(ResultSet rs, UUID owner, int id, boolean create) throws SQLException {
        if (rs.next()) {
            return new Vault(owner, id, rs.getString("inventory"), rs.getString("custom_name"), Material.getMaterial((String)rs.getString("icon")), rs.getString("trusted_players"));
        }
        return create ? new Vault(owner, id) : null;
    }

    @Nullable
    public Vault mapVault(ResultSet rs, UUID owner) throws SQLException {
        if (rs.next()) {
            return new Vault(owner, rs.getInt("id"), rs.getString("inventory"), rs.getString("custom_name"), Material.getMaterial((String)rs.getString("icon")), rs.getString("trusted_players"));
        }
        return null;
    }

    public List<Vault> mapVaults(ResultSet rs) throws SQLException {
        ArrayList<Vault> vaults = new ArrayList<Vault>();
        while (rs.next()) {
            vaults.add(new Vault(UUID.fromString(rs.getString("owner")), rs.getInt("id"), rs.getString("inventory"), rs.getString("custom_name"), Material.getMaterial((String)rs.getString("icon")), rs.getString("trusted_players")));
        }
        return vaults;
    }

    public List<SnapshotVault> mapSnapshotVaults(ResultSet rs, UUID owner) throws SQLException {
        ArrayList<SnapshotVault> vaults = new ArrayList<SnapshotVault>();
        while (rs.next()) {
            vaults.add(new SnapshotVault(owner, rs.getInt("id"), rs.getString("custom_name"), Material.getMaterial((String)rs.getString("icon")), rs.getString("trusted_players")));
        }
        return vaults;
    }

    public MaltsPlayer mapMaltsPlayer(ResultSet rs, UUID uuid) throws SQLException {
        if (rs.next()) {
            int maxVaults = rs.getInt("max_vaults");
            int maxWarehouseStock = rs.getInt("max_warehouse_stock");
            WarehouseMode warehouseMode = Util.getEnum(rs.getString("warehouse_mode"), WarehouseMode.class);
            QuickReturnClickType quickReturnClickType = Util.getEnum(rs.getString("quick_return_click_type"), QuickReturnClickType.class);
            return new MaltsPlayer(uuid, maxVaults, maxWarehouseStock, warehouseMode, quickReturnClickType);
        }
        return new MaltsPlayer(uuid);
    }

    public Warehouse mapWarehouse(ResultSet rs, UUID uuid) throws SQLException {
        EnumMap<Material, Stock> warehouseMap = new EnumMap<Material, Stock>(Material.class);
        while (rs.next()) {
            String mstring = rs.getString("material");
            Material material = Material.matchMaterial((String)mstring);
            int quantity = rs.getInt("quantity");
            long lastUpdate = rs.getLong("last_update");
            if (material == null) {
                throw new RuntimeException("Material " + mstring + " does not exist");
            }
            warehouseMap.put(material, new Stock(material, quantity, lastUpdate));
        }
        return new Warehouse(uuid, warehouseMap);
    }

    @Nullable
    public <T extends CachedObject> T cachedObject(UUID uuid, Class<T> objectClass) {
        Preconditions.checkNotNull((Object)uuid, (Object)"uuid cannot be null");
        Preconditions.checkNotNull(objectClass, (Object)"objectClass cannot be null");
        return (T)((CachedObject)this.cachedObjects.stream().filter(it -> it.getClass().equals(objectClass) && it.getUuid().equals(uuid)).findFirst().orElse(null));
    }

    public <T extends CachedObject> CompletableFuture<T> cacheObjectWithDefaultExpire(CompletableFuture<T> future) {
        long expire = ConfigManager.get(Config.class).storage().defaultObjectCacheTime();
        return this.cacheObject(future, expire);
    }

    public <T extends CachedObject> CompletableFuture<T> cacheObject(CompletableFuture<T> future, long expire) {
        return this.cacheObjectInternal(future, expire);
    }

    public <T extends CachedObject> CompletableFuture<T> cacheObject(CompletableFuture<T> future) {
        return this.cacheObjectInternal(future, null);
    }

    private <T extends CachedObject> CompletableFuture<T> cacheObjectInternal(CompletableFuture<T> future, Long expireTime) {
        return future.thenCompose(obj -> {
            if (obj == null) {
                return CompletableFuture.completedFuture(null);
            }
            ConcurrentLinkedQueue<CachedObject> concurrentLinkedQueue = this.cachedObjects;
            synchronized (concurrentLinkedQueue) {
                for (CachedObject cached : this.cachedObjects) {
                    if (!cached.getClass().equals(obj.getClass()) || !cached.getUuid().equals(obj.getUuid())) continue;
                    CachedObject alreadyCached = cached;
                    if (expireTime != null) {
                        long expireWhen = System.currentTimeMillis() + expireTime;
                        alreadyCached.setExpire(expireWhen);
                        Text.debug("Updated expire time for cached " + obj.getClass().getSimpleName() + ": " + String.valueOf(obj.getUuid()) + " to " + expireWhen);
                    }
                    Text.debug("Using cached " + obj.getClass().getSimpleName() + ": " + String.valueOf(obj.getUuid()));
                    return CompletableFuture.completedFuture(alreadyCached);
                }
            }
            if (expireTime != null) {
                long expireWhen = System.currentTimeMillis() + expireTime;
                obj.setExpire(expireWhen);
            }
            ConcurrentLinkedQueue<CachedObject> expireWhen = this.cachedObjects;
            synchronized (expireWhen) {
                this.cachedObjects.add((CachedObject)obj);
            }
            Object expireMsg = expireTime != null ? " until " + expireTime : "";
            Text.debug("Caching " + obj.getClass().getSimpleName() + ": " + String.valueOf(obj.getUuid()) + (String)expireMsg);
            return CompletableFuture.completedFuture(obj);
        });
    }

    public void uncacheObject(UUID uuid, Class<? extends CachedObject> objectClass) {
        CachedObject cachedObject = this.cachedObject(uuid, objectClass);
        if (cachedObject != null) {
            Text.debug("Uncaching " + cachedObject.getClass().getSimpleName() + ": " + String.valueOf(cachedObject.getUuid()));
            cachedObject.save(this);
            this.cachedObjects.remove(cachedObject);
        }
    }

    public String toString() {
        return "DataSource{singleThread=" + String.valueOf(this.singleThread) + ", hikari=" + String.valueOf(this.hikari) + ", cacheTask=" + String.valueOf(this.cacheTask) + ", cachedObjects=" + String.valueOf(this.cachedObjects) + "}";
    }

    public static void createInstance() {
        Config config = (Config)new ConfigManager().craft((Class)Config.class);
        DataSource.createInstance(config.storage());
    }

    public static void createInstance(Config.Storage config) throws IllegalStateException {
        TriState closed;
        TriState triState = closed = instance != null ? instance.isClosed() : TriState.TRUE;
        if (closed != TriState.TRUE) {
            throw new IllegalStateException(closed == TriState.ALTERNATIVE_STATE ? "DataSource is not properly closed." : "DataSource is not closed.");
        }
        instance = config.driver().supply(config);
        ((CompletableFuture)instance.setup().whenComplete((unused, throwable) -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                instance.cacheObject(instance.getMaltsPlayer(player.getUniqueId()));
                instance.cacheObject(instance.getWarehouse(player.getUniqueId()));
            }
        })).exceptionally(ex -> {
            throw new IllegalStateException("An exception/error occurred while setting up the DataSource", (Throwable)ex);
        });
    }

    @Generated
    public static DataSource getInstance() {
        return instance;
    }

    @Generated
    public HikariDataSource getHikari() {
        return this.hikari;
    }
}

