/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.utility;

import com.google.gson.Gson;
import dev.jsinco.malts.Malts;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.interfaces.EditMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class Util {
    public static final Gson GSON = new Gson();

    public static int getInteger(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Integer getInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static <E extends Enum<E>> E getEnum(String value, Class<E> enumClass) {
        if (value == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass, value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static NamespacedKey namespacedKey(String key) {
        return new NamespacedKey((Plugin)Malts.getInstance(), key);
    }

    public static ItemStack editMeta(ItemStack itemStack, EditMeta editMeta) {
        if (itemStack == null) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        editMeta.edit(itemMeta);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static <P, C> void setPersistentKey(ItemStack item, String key, PersistentDataType<P, C> type, C value) {
        Util.editMeta(item, meta -> meta.getPersistentDataContainer().set(Util.namespacedKey(key), type, value));
    }

    public static <P, C> ItemStack setPersistentKey(ItemStack item, NamespacedKey key, PersistentDataType<P, C> type, C value) {
        Util.editMeta(item, meta -> meta.getPersistentDataContainer().set(key, type, value));
        return item;
    }

    public static boolean hasPersistentKey(ItemStack item, NamespacedKey key) {
        return item.hasItemMeta() && item.getItemMeta().getPersistentDataContainer().has(key);
    }

    public static <P, C> C getPersistentKey(ItemStack item, NamespacedKey key, PersistentDataType<P, C> type) {
        if (item.hasItemMeta() && item.getItemMeta().getPersistentDataContainer().has(key)) {
            return (C)item.getItemMeta().getPersistentDataContainer().get(key, type);
        }
        return null;
    }

    public static String formatEnumerator(Enum<?> e) {
        return Util.formatEnumerator(e.name());
    }

    public static String formatEnumerator(String s) {
        Object name = s.toLowerCase().replace("_", " ");
        name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        for (int i = 0; i < ((String)name).length(); ++i) {
            if (((String)name).charAt(i) != ' ' || i + 1 >= ((String)name).length()) continue;
            name = ((String)name).substring(0, i + 1) + Character.toUpperCase(((String)name).charAt(i + 1)) + ((String)name).substring(i + 2);
        }
        return name;
    }

    public static int getMaterialAmount(Inventory inv, Material material) {
        int amount = 0;
        for (ItemStack item : inv.getStorageContents()) {
            if (item == null || item.getType() != material || item.hasItemMeta()) continue;
            amount += item.getAmount();
        }
        return amount;
    }

    public static int getAmountInvCanHold(Inventory inv, Material material) {
        int amount = 0;
        for (ItemStack item : inv.getStorageContents()) {
            if (item == null) {
                amount += material.getMaxStackSize();
                continue;
            }
            if (item.getType() != material || item.hasItemMeta()) continue;
            amount += item.getMaxStackSize() - item.getAmount();
        }
        return amount;
    }

    public static List<String> tryGetNextNumberArg(String arg) {
        int num = Util.getInteger(arg, -1);
        return IntStream.range(0, 10).mapToObj(i -> num < 0 ? String.valueOf(i) : "" + num + i).toList();
    }

    @SafeVarargs
    public static String replace(String string, Couple<String, Object> ... pairs) {
        if (string == null) {
            return null;
        }
        String newString = string;
        for (Couple<String, Object> pair : pairs) {
            Object object = pair.b();
            if (object instanceof Integer) {
                Integer integer = (Integer)object;
                newString = newString.replace(pair.a(), String.format("%,d", integer));
                continue;
            }
            object = pair.b();
            if (object instanceof Double) {
                Double doubleValue = (Double)object;
                newString = newString.replace(pair.a(), String.format("%,.2f", doubleValue));
                continue;
            }
            newString = newString.replace(pair.a(), String.valueOf(pair.b()));
        }
        return newString;
    }

    @SafeVarargs
    public static Component replaceComponents(Component passed, Couple<String, Object> ... pairs) {
        if (passed == null) {
            return null;
        }
        Component newComponent = passed;
        for (Couple<String, Object> pair : pairs) {
            Object object = pair.b();
            if (object instanceof Component) {
                Component component = (Component)object;
                newComponent = newComponent.replaceText(builder -> builder.match(Pattern.quote((String)pair.a())).replacement((ComponentLike)component));
                continue;
            }
            object = pair.b();
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                List<Component> components = collection.stream().map(obj -> {
                    if (obj instanceof Component) {
                        Component comp = (Component)obj;
                        return comp;
                    }
                    return Component.text((String)String.valueOf(obj));
                }).toList();
                Component joined = Component.join((JoinConfiguration)JoinConfiguration.newlines(), components);
                newComponent = newComponent.replaceText(builder -> builder.match(Pattern.quote((String)pair.a())).replacement((ComponentLike)joined));
                continue;
            }
            newComponent = newComponent.replaceText(builder -> builder.match(Pattern.quote((String)pair.a())).replacement(String.valueOf(pair.b())));
        }
        return newComponent;
    }

    public static List<String> replaceAll(List<String> list, String charArray, String charArrayReplacement) {
        return list.stream().map(s -> s.replace(charArray, charArrayReplacement)).toList();
    }

    public static List<String> replaceStringWithList(List<String> list, String charArray, List<String> charArrayReplacement) {
        ArrayList<String> newList = new ArrayList<String>(list);
        for (int i = 0; i < newList.size(); ++i) {
            String s = (String)newList.get(i);
            if (!s.contains(charArray)) continue;
            newList.remove(i);
            newList.addAll(i, charArrayReplacement);
        }
        return newList;
    }

    public static List<String> replaceAll(List<String> list, Couple<String, Object> ... pairs) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String string : list) {
            String newString = Util.replace(string, pairs);
            newList.add(newString);
        }
        return newList;
    }

    public static <T> List<T> plusList(List<T> list, T ... items) {
        ArrayList<T> newList = new ArrayList<T>(list);
        newList.addAll(List.of(items));
        return newList;
    }

    public static <T> List<T> plusFirstIndex(List<T> list, T ... items) {
        ArrayList<T> newList = new ArrayList<T>(items.length + list.size());
        newList.addAll(List.of(items));
        newList.addAll(list);
        return newList;
    }
}

