/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.gui;

import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.IntPair;
import dev.jsinco.malts.configuration.files.Config;
import dev.jsinco.malts.configuration.files.GuiConfig;
import dev.jsinco.malts.configuration.files.Lang;
import dev.jsinco.malts.enums.QuickReturnClickType;
import dev.jsinco.malts.enums.TriState;
import dev.jsinco.malts.enums.WarehouseMode;
import dev.jsinco.malts.gui.MaltsGui;
import dev.jsinco.malts.gui.PaginatedGui;
import dev.jsinco.malts.gui.YourVaultsGui;
import dev.jsinco.malts.gui.item.GuiItem;
import dev.jsinco.malts.gui.item.ItemConfirmation;
import dev.jsinco.malts.gui.item.UncontainedGuiItem;
import dev.jsinco.malts.obj.MaltsPlayer;
import dev.jsinco.malts.obj.Warehouse;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Executors;
import dev.jsinco.malts.utility.ItemStacks;
import dev.jsinco.malts.utility.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class WarehouseGui
extends MaltsGui {
    private static final GuiConfig cfg = ConfigManager.get(GuiConfig.class);
    private static final Lang lng = ConfigManager.get(Lang.class);
    private PaginatedGui paginatedGui;
    private Warehouse warehouse;
    private MaltsPlayer maltsPlayer;
    private ClickType state;
    private final GuiItem previousPage = GuiItem.builder().index(() -> cfg.warehouseGui().previousPage().slot()).itemStack(b -> b.displayName(cfg.warehouseGui().previousPage().title()).material(cfg.warehouseGui().previousPage().material()).lore(cfg.warehouseGui().previousPage().lore())).action(e -> {
        Player player = (Player)e.getWhoClicked();
        Inventory inv = this.paginatedGui.getPrevious(e.getInventory());
        if (inv != null) {
            player.openInventory(inv);
        } else {
            lng.entry(l -> l.gui().firstPage(), (Audience)player, new Couple[0]);
        }
    }).build();
    private final GuiItem nextPage = GuiItem.builder().index(() -> cfg.warehouseGui().nextPage().slot()).itemStack(b -> b.displayName(cfg.warehouseGui().nextPage().title()).material(cfg.warehouseGui().nextPage().material()).lore(cfg.warehouseGui().nextPage().lore())).action(e -> {
        Player player = (Player)e.getWhoClicked();
        Inventory inv = this.paginatedGui.getNext(e.getInventory());
        if (inv != null) {
            player.openInventory(inv);
        } else {
            lng.entry(l -> l.gui().lastPage(), (Audience)player, new Couple[0]);
        }
    }).build();
    private final UncontainedGuiItem managerButton = UncontainedGuiItem.builder().index(() -> cfg.warehouseGui().managerButton().slot()).itemStack(b -> b.stringReplacements(Couple.of("{mode}", Util.formatEnumerator(this.maltsPlayer.getWarehouseMode()))).displayName(cfg.warehouseGui().managerButton().name()).material(cfg.warehouseGui().managerButton().material()).lore(cfg.warehouseGui().managerButton().lore())).action((event, self, isClicked) -> {
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedItem == null) {
            return;
        }
        ItemStack iconItem = Arrays.stream(event.getInventory().getContents()).filter(Objects::nonNull).filter(item -> Util.hasPersistentKey(item, self.key())).findFirst().orElse(null);
        if (event.getClick() == ClickType.SHIFT_LEFT && isClicked) {
            WarehouseMode mode = this.maltsPlayer.getWarehouseMode();
            WarehouseMode nextMode = WarehouseMode.getNextMode(mode, player);
            if (nextMode == mode) {
                return;
            }
            this.maltsPlayer.setWarehouseMode(nextMode);
            event.getInventory().setItem(cfg.warehouseGui().managerButton().slot(), self.guiItemStack());
            lng.entry(l -> l.warehouse().changedMode(), (Audience)player, Couple.of("{mode}", Util.formatEnumerator(this.maltsPlayer.getWarehouseMode())));
            return;
        }
        ItemConfirmation itemConfirmation = new ItemConfirmation(iconItem);
        if (!itemConfirmation.isConfirmed()) {
            if (isClicked) {
                itemConfirmation.setConfirmation(!itemConfirmation.isConfirmed());
                this.state = event.getClick();
            }
            return;
        }
        Material material = clickedItem.getType();
        switch (this.state) {
            case LEFT: {
                if (clickedInventory == event.getInventory()) break;
                if (!this.warehouse.canStock(material)) {
                    lng.entry(l -> l.warehouse().blacklistedItem(), (Audience)player, Couple.of("{material}", Util.formatEnumerator(material)));
                    break;
                }
                if (!this.warehouse.hasCompartment(material)) {
                    this.warehouse.stockItem(material, 0);
                    this.refresh(player);
                    break;
                }
                lng.entry(l -> l.warehouse().compartmentAlreadyExists(), (Audience)player, Couple.of("{material}", Util.formatEnumerator(material)));
                break;
            }
            case RIGHT: {
                if (clickedInventory != event.getInventory()) break;
                TriState triState = this.warehouse.removeCompartment(material);
                if (triState == TriState.TRUE) {
                    lng.entry(l -> l.warehouse().removedCompartment(), (Audience)player, Couple.of("{material}", Util.formatEnumerator(material)));
                    this.refresh(player);
                    break;
                }
                if (triState == TriState.FALSE) {
                    lng.entry(l -> l.warehouse().cannotRemoveCompartment(), (Audience)player, new Couple[0]);
                    break;
                }
                lng.entry(l -> l.warehouse().compartmentDoesNotExist(), (Audience)player, new Couple[0]);
            }
        }
        this.state = null;
        itemConfirmation.setConfirmation(false);
        event.setCancelled(true);
    }).build();
    private final UncontainedGuiItem statusIcon = UncontainedGuiItem.builder().index(() -> cfg.warehouseGui().statusIcon().slot()).itemStack(b -> b.stringReplacements(Couple.of("{name}", this.maltsPlayer.name()), Couple.of("{stock}", this.warehouse.currentStockQuantity()), Couple.of("{maxStock}", this.maltsPlayer.getCalculatedMaxWarehouseStock()), Couple.of("{stockPercent}", this.warehouseUsagePercent())).displayName(cfg.warehouseGui().statusIcon().name()).lore(cfg.warehouseGui().statusIcon().lore()).material(cfg.warehouseGui().statusIcon().material()).headOwner(cfg.warehouseGui().statusIcon().headOwner())).action((event, self, isClicked) -> {
        ItemStack clickedItem = event.getCurrentItem();
        Inventory inv = event.getInventory();
        if (event.getClickedInventory() == inv && !ItemStacks.borderItem().isSimilar(clickedItem)) {
            Executors.delayedSync(1L, () -> inv.setItem(cfg.warehouseGui().statusIcon().slot(), self.guiItemStack()));
        }
    }).build();

    public WarehouseGui(Warehouse warehouse, MaltsPlayer maltsPlayer) {
        super(cfg.warehouseGui().title(), cfg.warehouseGui().size());
        this.maltsPlayer = maltsPlayer;
        this.warehouse = warehouse;
        this.autoRegister(false);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (GuiItem guiItem : warehouse.stockAsGuiItems(-1)) {
            itemStacks.add(guiItem.guiItemStack());
            this.addGuiItem(guiItem);
        }
        IntPair slots = cfg.warehouseGui().warehouseItem().slots();
        List<Integer> ignoredSlots = cfg.warehouseGui().warehouseItem().ignoredSlots();
        if (cfg.warehouseGui().borders()) {
            int i = 0;
            for (ItemStack itemStack : this.inventory.getContents()) {
                if (itemStack == null && (!slots.includes(i) || ignoredSlots.contains(i))) {
                    this.inventory.setItem(i, ItemStacks.borderItem());
                }
                ++i;
            }
        }
        this.paginatedGui = PaginatedGui.builder().name(cfg.warehouseGui().title()).items(itemStacks).startEndSlots((Integer)slots.a(), (Integer)slots.b()).ignoredSlots(ignoredSlots).base(this.getInventory()).build();
    }

    @Override
    public void onPreInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (this.warehouse.isExpired()) {
            lng.entry(l -> l.gui().viewExpired(), (Audience)player, new Couple[0]);
            event.setCancelled(true);
            player.closeInventory();
            return;
        }
        super.onPreInventoryClick(event);
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Config.QuickReturn quickReturn = ConfigManager.get(Config.class).quickReturn();
        event.setCancelled(true);
        MaltsPlayer maltsPlayer = DataSource.getInstance().cachedObject(player.getUniqueId(), MaltsPlayer.class);
        QuickReturnClickType quickReturnClickType = maltsPlayer.getQuickReturnClickType();
        if (event.getClickedInventory() == null && quickReturn.enabled() && quickReturnClickType != null && quickReturnClickType.getBacking() == event.getClick()) {
            YourVaultsGui gui = new YourVaultsGui(maltsPlayer);
            gui.open(player);
        }
    }

    @Override
    public void openImpl(Player player) {
        player.openInventory(this.paginatedGui.getPage(0));
    }

    private void refresh(Player player) {
        WarehouseGui newGui = new WarehouseGui(this.warehouse, this.maltsPlayer);
        newGui.open(player);
    }

    private double warehouseUsagePercent() {
        int dem = this.maltsPlayer.getCalculatedMaxWarehouseStock();
        if (dem == 0) {
            return 0.0;
        }
        return (double)this.warehouse.currentStockQuantity() / (double)dem * 100.0;
    }
}

