/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.api;

import dev.jsinco.malts.Malts;
import dev.jsinco.malts.commands.interfaces.SubCommand;
import dev.jsinco.malts.configuration.OkaeriFile;
import dev.jsinco.malts.configuration.files.Config;
import dev.jsinco.malts.configuration.files.GuiConfig;
import dev.jsinco.malts.configuration.files.Lang;
import dev.jsinco.malts.importers.Importer;
import dev.jsinco.malts.integration.Integration;
import dev.jsinco.malts.obj.MaltsPlayer;
import dev.jsinco.malts.obj.SnapshotVault;
import dev.jsinco.malts.obj.Vault;
import dev.jsinco.malts.obj.Warehouse;
import dev.jsinco.malts.registry.Registry;
import dev.jsinco.malts.storage.DataSource;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MaltsAPI {
    private MaltsAPI() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @NotNull
    public static Malts getMaltsInstance() {
        return Malts.getInstance();
    }

    @NotNull
    public static Registry<OkaeriFile> getConfigRegistry() {
        return Registry.CONFIGS;
    }

    @NotNull
    public static Registry<Importer> getImporterRegistry() {
        return Registry.IMPORTERS;
    }

    @NotNull
    public static Registry<SubCommand> getSubCommandRegistry() {
        return Registry.SUB_COMMANDS;
    }

    @NotNull
    public static Registry<Integration> getIntegrationRegistry() {
        return Registry.INTEGRATIONS;
    }

    @NotNull
    public static Config getConfig() {
        return MaltsAPI.getConfigRegistry().get(Config.class);
    }

    @NotNull
    public static GuiConfig getGuiConfig() {
        return MaltsAPI.getConfigRegistry().get(GuiConfig.class);
    }

    @NotNull
    public static Lang getLang() {
        return MaltsAPI.getConfigRegistry().get(Lang.class);
    }

    @ApiStatus.Internal
    @NotNull
    public static DataSource getDataSource() {
        return DataSource.getInstance();
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull Vault> getVault(UUID owner, int id) {
        return MaltsAPI.getDataSource().getVault(owner, id);
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull List<SnapshotVault>> getVaults(UUID owner) {
        return MaltsAPI.getDataSource().getVaults(owner);
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull Void> saveVault(Vault vault) {
        return MaltsAPI.getDataSource().saveVault(vault);
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull Boolean> deleteVault(UUID owner, int id) {
        return MaltsAPI.getDataSource().deleteVault(owner, id);
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull Warehouse> getOrCacheWarehouseWithDefaultExpire(UUID owner) {
        DataSource dataSource = MaltsAPI.getDataSource();
        return dataSource.cacheObjectWithDefaultExpire(dataSource.getWarehouse(owner));
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull Warehouse> getOrCacheWarehouse(UUID owner, long expireMillis) {
        DataSource dataSource = MaltsAPI.getDataSource();
        return dataSource.cacheObject(dataSource.getWarehouse(owner), expireMillis);
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull Warehouse> getOrCacheWarehouse(UUID owner) {
        return MaltsAPI.getDataSource().getWarehouse(owner);
    }

    @Nullable
    public static Warehouse getCachedWarehouse(UUID owner) {
        return MaltsAPI.getDataSource().cachedObject(owner, Warehouse.class);
    }

    public static void uncacheWarehouse(UUID owner) {
        MaltsAPI.getDataSource().uncacheObject(owner, Warehouse.class);
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull MaltsPlayer> getOrCacheMaltsPlayerWithDefaultExpire(UUID uuid) {
        DataSource dataSource = MaltsAPI.getDataSource();
        return dataSource.cacheObjectWithDefaultExpire(dataSource.getMaltsPlayer(uuid));
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull MaltsPlayer> getOrCacheMaltsPlayer(UUID uuid, long expireMillis) {
        DataSource dataSource = MaltsAPI.getDataSource();
        return dataSource.cacheObject(dataSource.getMaltsPlayer(uuid), expireMillis);
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull MaltsPlayer> getOrCacheMaltsPlayer(UUID uuid) {
        return MaltsAPI.getDataSource().getMaltsPlayer(uuid);
    }

    @Nullable
    public static MaltsPlayer getCachedMaltsPlayer(UUID uuid) {
        return MaltsAPI.getDataSource().cachedObject(uuid, MaltsPlayer.class);
    }

    public static void uncacheMaltsPlayer(UUID uuid) {
        MaltsAPI.getDataSource().uncacheObject(uuid, MaltsPlayer.class);
    }
}

