/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.commands.subcommands;

import dev.jsinco.malts.Malts;
import dev.jsinco.malts.commands.interfaces.SubCommand;
import dev.jsinco.malts.gui.VaultOtherGui;
import dev.jsinco.malts.obj.MaltsPlayer;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Executors;
import dev.jsinco.malts.utility.Util;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VaultOtherCommand
implements SubCommand {
    @Override
    public boolean execute(Malts plugin, CommandSender sender, String label, List<String> args) {
        if (args.isEmpty()) {
            return false;
        }
        Player player = (Player)sender;
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args.getFirst());
        DataSource dataSource = DataSource.getInstance();
        if (args.size() < 2) {
            VaultOtherGui vaultOtherGui = new VaultOtherGui(player, target);
            vaultOtherGui.open(player);
            return true;
        }
        int vaultId = Util.getInteger(args.get(1), 1);
        dataSource.getVault(target.getUniqueId(), vaultId).thenAccept(vault -> {
            if (vault == null) {
                lng.entry(l -> l.command().vaultOther().noVaultFound(), (CommandSender)player, Couple.of("{id}", vaultId), Couple.of("{name}", target.getName()));
                return;
            }
            if (!vault.canAccess(player)) {
                lng.entry(l -> l.vaults().noAccess(), (CommandSender)player, Couple.of("{id}", vaultId));
                return;
            }
            Executors.sync(() -> vault.open(player));
            lng.entry(l -> l.vaults().opening(), (CommandSender)player, Couple.of("{id}", vaultId), Couple.of("{vaultName}", vault.getCustomName()));
        });
        return true;
    }

    @Override
    public List<String> tabComplete(Malts plugin, CommandSender sender, String label, List<String> args) {
        if (args.size() <= 1) {
            return null;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args.getFirst());
        DataSource dataSource = DataSource.getInstance();
        MaltsPlayer maltsPlayer = dataSource.cachedObject(offlinePlayer.getUniqueId(), MaltsPlayer.class);
        if (maltsPlayer == null) {
            return Util.tryGetNextNumberArg(args.get(1));
        }
        return IntStream.rangeClosed(1, maltsPlayer.getCalculatedMaxVaults()).mapToObj(String::valueOf).collect(Collectors.toList());
    }

    @Override
    public String permission() {
        return "malts.command.vaultother";
    }

    @Override
    public boolean playerOnly() {
        return true;
    }

    @Override
    public String name() {
        return "vaultother";
    }
}

