/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.events;

import dev.jsinco.malts.api.events.vault.VaultClickEvent;
import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.files.Config;
import dev.jsinco.malts.gui.MaltsGui;
import dev.jsinco.malts.gui.VaultOtherGui;
import dev.jsinco.malts.gui.YourVaultsGui;
import dev.jsinco.malts.obj.MaltsPlayer;
import dev.jsinco.malts.obj.Vault;
import dev.jsinco.malts.storage.DataSource;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.InventoryHolder;

public class VaultListener
implements Listener {
    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        InventoryHolder holder = event.getInventory().getHolder(false);
        if (!(holder instanceof Vault)) {
            return;
        }
        Vault vault = (Vault)holder;
        vault.update((Player)event.getPlayer());
        DataSource dataSource = DataSource.getInstance();
        dataSource.saveVault(vault);
    }

    @EventHandler
    public void onInventoryInteract(InventoryDragEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof Vault)) {
            return;
        }
        Vault vault = (Vault)inventoryHolder;
        vault.update((Player)event.getWhoClicked());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof Vault)) {
            return;
        }
        Vault vault = (Vault)inventoryHolder;
        VaultClickEvent vaultClickEvent = new VaultClickEvent(vault, event);
        if (!vaultClickEvent.callEvent()) {
            event.setCancelled(true);
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Config.QuickReturn quickReturn = ConfigManager.get(Config.class).quickReturn();
        if (event.getClickedInventory() != null) {
            vault.update(player);
            return;
        }
        if (!quickReturn.enabled() || event.getClick() != quickReturn.clickType()) {
            return;
        }
        MaltsPlayer maltsPlayer = DataSource.getInstance().cachedObject(player.getUniqueId(), MaltsPlayer.class);
        MaltsGui gui = !vault.getOwner().equals(player.getUniqueId()) ? new VaultOtherGui(player, Bukkit.getOfflinePlayer((UUID)vault.getOwner())) : new YourVaultsGui(maltsPlayer);
        gui.open(player);
    }
}

