/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.gui;

import dev.jsinco.malts.api.events.gui.MaltsGuiOpenEvent;
import dev.jsinco.malts.gui.item.AbstractGuiItem;
import dev.jsinco.malts.gui.item.IgnoreAutoRegister;
import dev.jsinco.malts.obj.MaltsInventory;
import dev.jsinco.malts.utility.Text;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public abstract class MaltsGui
implements MaltsInventory {
    protected final Inventory inventory;
    protected final List<AbstractGuiItem> guiItems;

    public MaltsGui(String title, int size) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (Component)Text.mm(title));
        this.guiItems = new ArrayList<AbstractGuiItem>();
    }

    public abstract void onInventoryClick(InventoryClickEvent var1);

    public abstract void openImpl(Player var1);

    public void open(Player player) {
        MaltsGuiOpenEvent event = new MaltsGuiOpenEvent(this, player);
        if (event.callEvent()) {
            this.openImpl(event.getPlayer());
        }
    }

    public void addGuiItem(AbstractGuiItem item) {
        int index = item.index() != null ? item.index() : -1;
        this.addGuiItem(item, index);
    }

    public void addGuiItem(AbstractGuiItem item, int index) {
        if (index >= 0 && index < this.inventory.getSize()) {
            this.inventory.setItem(index, item.guiItemStack());
        }
        this.guiItems.add(item);
    }

    public void onPreInventoryClick(InventoryClickEvent event) {
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem != null) {
            for (AbstractGuiItem guiItem : this.guiItems) {
                guiItem.onClick(event, clickedItem);
            }
        }
        this.onInventoryClick(event);
    }

    protected void autoRegister(Class<?> forClass) {
        for (Field field : forClass.getDeclaredFields()) {
            field.setAccessible(true);
            if (!AbstractGuiItem.class.isAssignableFrom(field.getType()) || field.isAnnotationPresent(IgnoreAutoRegister.class)) continue;
            try {
                AbstractGuiItem guiItem = (AbstractGuiItem)field.get(this);
                if (guiItem != null) {
                    this.addGuiItem(guiItem);
                    continue;
                }
                Text.error("GuiItem field '" + field.getName() + "' is null in " + forClass.getSimpleName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void autoRegister(boolean walk) {
        if (walk) {
            for (currentClass = this.getClass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                this.autoRegister(currentClass);
            }
        } else {
            this.autoRegister(currentClass);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public List<AbstractGuiItem> getGuiItems() {
        return this.guiItems;
    }
}

