/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.utility;

import dev.jsinco.malts.Malts;
import dev.jsinco.malts.utility.ExceptionUtil;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.Nullable;

public final class Executors {
    private static final Malts instance = Malts.getInstance();

    public static ScheduledTask runRepeatingAsync(long delay, long period, TimeUnit timeUnit, Consumer<ScheduledTask> consumer) {
        return Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)instance, consumer, delay, period, timeUnit);
    }

    public static ScheduledTask runDelayedAsync(long delay, TimeUnit timeUnit, Consumer<ScheduledTask> consumer) {
        return Bukkit.getAsyncScheduler().runDelayed((Plugin)instance, consumer, delay, timeUnit);
    }

    public static ScheduledTask runRepeatingAsync(long period, TimeUnit timeUnit, Consumer<ScheduledTask> consumer) {
        return Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)instance, consumer, 0L, period, timeUnit);
    }

    public static ScheduledTask runAsync(Consumer<ScheduledTask> consumer) {
        return Bukkit.getAsyncScheduler().runNow((Plugin)instance, consumer);
    }

    public static BukkitTask runAsync(Runnable runnable) {
        return Bukkit.getScheduler().runTaskAsynchronously((Plugin)instance, runnable);
    }

    @Nullable
    public static BukkitTask runAsyncWithSQLException(ExceptionUtil.ThrowingSQLException runnable) {
        if (Malts.isShutdown()) {
            Executors.runSync(() -> ExceptionUtil.runWithSQLExceptionHandling(runnable));
            return null;
        }
        return Executors.runAsync(() -> ExceptionUtil.runWithSQLExceptionHandling(runnable));
    }

    public static <U> CompletableFuture<U> supplyAsyncWithSQLException(ExceptionUtil.ThrowingSQLExceptionWithReturn<U> supplier) {
        if (!Malts.isShutdown()) {
            return CompletableFuture.supplyAsync(() -> ExceptionUtil.runWithSQLExceptionHandling(supplier)).exceptionally(throwable -> {
                throwable.printStackTrace();
                return null;
            });
        }
        return CompletableFuture.completedFuture(ExceptionUtil.runWithSQLExceptionHandling(supplier));
    }

    public static <U> CompletableFuture<U> supplyAsyncWithSQLException(ExceptionUtil.ThrowingSQLExceptionWithReturn<U> supplier, Executor executor) {
        if (!Malts.isShutdown()) {
            return CompletableFuture.supplyAsync(() -> ExceptionUtil.runWithSQLExceptionHandling(supplier), executor).exceptionally(throwable -> {
                throwable.printStackTrace();
                return null;
            });
        }
        return CompletableFuture.completedFuture(ExceptionUtil.runWithSQLExceptionHandling(supplier));
    }

    public static BukkitTask delayedSync(long delay, Runnable runnable) {
        return Bukkit.getScheduler().runTaskLater((Plugin)instance, runnable, delay);
    }

    public static BukkitTask sync(Runnable runnable) {
        return Bukkit.getScheduler().runTask((Plugin)instance, runnable);
    }

    public static void runSync(Runnable runnable) {
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
        } else {
            Executors.sync(runnable);
        }
    }

    public static ExecutorService newSingleThreadExecutor() {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setContextClassLoader(Malts.class.getClassLoader());
            return thread;
        });
    }
}

