/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts;

import dev.jsinco.malts.commands.MaltsBaseCommand;
import dev.jsinco.malts.commands.VaultNameBaseCommand;
import dev.jsinco.malts.commands.VaultOtherBaseCommand;
import dev.jsinco.malts.commands.VaultSearchBaseCommand;
import dev.jsinco.malts.commands.VaultsBaseCommand;
import dev.jsinco.malts.commands.WarehouseBaseCommand;
import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.events.ChatPromptInputListener;
import dev.jsinco.malts.events.GuiListener;
import dev.jsinco.malts.events.PlayerListener;
import dev.jsinco.malts.events.VaultListener;
import dev.jsinco.malts.events.WarehouseListener;
import dev.jsinco.malts.obj.MaltsInventory;
import dev.jsinco.malts.storage.DataSource;
import lombok.Generated;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Malts
extends JavaPlugin {
    private static Malts instance;
    private static boolean shutdown;

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        DataSource.createInstance();
        ConfigManager.createTranslationConfigs();
        this.getServer().getPluginCommand("malts").setExecutor((CommandExecutor)new MaltsBaseCommand());
        this.getServer().getPluginCommand("vaults").setExecutor((CommandExecutor)new VaultsBaseCommand());
        this.getServer().getPluginCommand("warehouse").setExecutor((CommandExecutor)new WarehouseBaseCommand());
        this.getServer().getPluginCommand("vaultother").setExecutor((CommandExecutor)new VaultOtherBaseCommand());
        this.getServer().getPluginCommand("vaultname").setExecutor((CommandExecutor)new VaultNameBaseCommand());
        this.getServer().getPluginCommand("vaultsearch").setExecutor((CommandExecutor)new VaultSearchBaseCommand());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new VaultListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WarehouseListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GuiListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatPromptInputListener(), (Plugin)this);
    }

    public void onDisable() {
        shutdown = true;
        DataSource dataSource = DataSource.getInstance();
        for (Player player : this.getServer().getOnlinePlayers()) {
            Inventory inv = player.getOpenInventory().getTopInventory();
            if (inv == null || !(inv.getHolder(false) instanceof MaltsInventory)) continue;
            player.closeInventory();
        }
        dataSource.close();
    }

    @Generated
    public static Malts getInstance() {
        return instance;
    }

    @Generated
    public static boolean isShutdown() {
        return shutdown;
    }
}

