/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.commands;

import dev.jsinco.malts.Malts;
import dev.jsinco.malts.commands.interfaces.SubCommand;
import dev.jsinco.malts.commands.subcommands.HelpCommand;
import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.files.Config;
import dev.jsinco.malts.configuration.files.Lang;
import dev.jsinco.malts.registry.Registry;
import dev.jsinco.malts.utility.Couple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaltsBaseCommand
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (args.length == 0 && sender.hasPermission("malts.command.base")) {
            String baseCommandBehavior = ConfigManager.get(Config.class).baseCommandBehavior();
            SubCommand subCommand = Registry.SUB_COMMANDS.get(baseCommandBehavior);
            if (subCommand == null || subCommand.playerOnly() && !(sender instanceof Player) || subCommand.permission() != null && !sender.hasPermission(subCommand.permission())) {
                subCommand = Registry.SUB_COMMANDS.get(HelpCommand.class);
            }
            return subCommand.execute(Malts.getInstance(), sender, label, new ArrayList<String>());
        }
        String subCommandName = args[0].toLowerCase();
        SubCommand subCommand = Registry.SUB_COMMANDS.get(subCommandName);
        Lang lang = ConfigManager.get(Lang.class);
        if (subCommand == null) {
            lang.entry(l -> l.command().base().unknownCommand(), sender, new Couple[0]);
            return true;
        }
        if (subCommand.playerOnly() && !(sender instanceof Player)) {
            lang.entry(l -> l.command().base().playerOnly(), sender, new Couple[0]);
            return true;
        }
        if (subCommand.permission() != null && !sender.hasPermission(subCommand.permission())) {
            lang.entry(l -> l.command().base().noPermission(), sender, new Couple[0]);
            return true;
        }
        ArrayList<String> commandArgs = new ArrayList<String>(List.of(args));
        commandArgs.removeFirst();
        boolean result = subCommand.execute(Malts.getInstance(), sender, label, commandArgs);
        if (!result) {
            lang.entry(l -> l.command().base().invalidUsage(), sender, new Couple[0]);
        }
        return result;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (args.length <= 1) {
            return Registry.SUB_COMMANDS.stream().filter(it -> {
                String perm = ((SubCommand)it.getValue()).permission();
                return perm == null || sender.hasPermission(perm);
            }).map(Map.Entry::getKey).toList();
        }
        String subCommandName = args[0].toLowerCase();
        SubCommand subCommand = Registry.SUB_COMMANDS.get(subCommandName);
        if (subCommand == null || subCommand.permission() != null && !sender.hasPermission(subCommand.permission())) {
            return null;
        }
        ArrayList<String> commandArgs = new ArrayList<String>(List.of(args));
        commandArgs.removeFirst();
        return subCommand.tabComplete(Malts.getInstance(), sender, label, commandArgs);
    }
}

