/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.registry;

import dev.jsinco.malts.commands.interfaces.SubCommand;
import dev.jsinco.malts.commands.subcommands.HelpCommand;
import dev.jsinco.malts.commands.subcommands.ImportCommand;
import dev.jsinco.malts.commands.subcommands.MaxCommand;
import dev.jsinco.malts.commands.subcommands.QuickReturnCommand;
import dev.jsinco.malts.commands.subcommands.ReloadCommand;
import dev.jsinco.malts.commands.subcommands.SearchCommand;
import dev.jsinco.malts.commands.subcommands.VaultAdminCommand;
import dev.jsinco.malts.commands.subcommands.VaultNameCommand;
import dev.jsinco.malts.commands.subcommands.VaultOtherCommand;
import dev.jsinco.malts.commands.subcommands.VaultsCommand;
import dev.jsinco.malts.commands.subcommands.WarehouseAdminCommand;
import dev.jsinco.malts.commands.subcommands.WarehouseCommand;
import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.OkaeriFile;
import dev.jsinco.malts.configuration.files.Config;
import dev.jsinco.malts.configuration.files.GuiConfig;
import dev.jsinco.malts.configuration.files.Lang;
import dev.jsinco.malts.importers.AxVaultsImporter;
import dev.jsinco.malts.importers.Importer;
import dev.jsinco.malts.importers.PlayerVaultsImporter;
import dev.jsinco.malts.integration.Integration;
import dev.jsinco.malts.integration.IntegrationCrafter;
import dev.jsinco.malts.integration.compiled.BStatsIntegration;
import dev.jsinco.malts.integration.external.CoreProtectIntegration;
import dev.jsinco.malts.integration.external.PlayerPointsIntegration;
import dev.jsinco.malts.integration.external.VaultIntegration;
import dev.jsinco.malts.registry.RegistryCrafter;
import dev.jsinco.malts.registry.RegistryItem;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class Registry<T extends RegistryItem>
implements Iterable<Map.Entry<String, T>> {
    public static final Registry<SubCommand> SUB_COMMANDS = Registry.fromClasses(VaultsCommand.class, WarehouseCommand.class, ImportCommand.class, VaultOtherCommand.class, WarehouseAdminCommand.class, MaxCommand.class, VaultAdminCommand.class, ReloadCommand.class, HelpCommand.class, QuickReturnCommand.class, VaultNameCommand.class, SearchCommand.class);
    public static final Registry<Importer> IMPORTERS = Registry.fromClasses(PlayerVaultsImporter.class, AxVaultsImporter.class);
    public static final Registry<OkaeriFile> CONFIGS = Registry.fromClassesWithCrafter(new ConfigManager(), Config.class, GuiConfig.class, Lang.class);
    public static final Registry<Integration> INTEGRATIONS = Registry.fromClassesWithCrafter(new IntegrationCrafter(), BStatsIntegration.class, CoreProtectIntegration.class, VaultIntegration.class, PlayerPointsIntegration.class);
    private final Map<String, T> map = new HashMap<String, T>();

    public Registry(Collection<T> values) {
        values.forEach(item -> this.map.put(item.name(), item));
    }

    public T get(String identifier) {
        return (T)((RegistryItem)this.map.get(identifier));
    }

    public <A extends T> A get(Class<A> clazz) {
        return (A)((RegistryItem)this.map.values().stream().filter(it -> it.getClass().equals(clazz)).findFirst().orElse(null));
    }

    public Collection<T> values() {
        return this.map.values();
    }

    public Collection<String> keySet() {
        return this.map.keySet();
    }

    public Stream<Map.Entry<String, T>> stream() {
        return this.map.entrySet().stream();
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<String, T>> iterator() {
        return this.map.entrySet().iterator();
    }

    @SafeVarargs
    public static <E extends RegistryItem> Registry<E> fromClassesWithCrafter(RegistryCrafter crafter, Class<? extends E> ... classes) {
        ArrayList<RegistryItem> eClasses = new ArrayList<RegistryItem>();
        for (Class<? extends E> clazz : classes) {
            if (crafter instanceof RegistryCrafter.Extension) {
                RegistryCrafter.Extension crafter1 = (RegistryCrafter.Extension)crafter;
                eClasses.add((RegistryItem)crafter1.craft(clazz));
                continue;
            }
            if (crafter instanceof RegistryCrafter.NoExtension) {
                RegistryCrafter.NoExtension crafter2 = (RegistryCrafter.NoExtension)crafter;
                eClasses.add((RegistryItem)crafter2.craft(clazz));
                continue;
            }
            throw new IllegalArgumentException("Unknown crafter type");
        }
        return new Registry<RegistryItem>(eClasses.stream().filter(Objects::nonNull).toList());
    }

    @SafeVarargs
    public static <E extends RegistryItem> Registry<E> fromClasses(Class<? extends E> ... classes) {
        return ConstructableClassBuilder.builder().addClasses(classes).build();
    }

    public static <E extends RegistryItem> Registry<E> fromClasses(Collection<Class<?>> constructorParamTypes, Collection<Object> constructorParams, Collection<Class<? extends E>> classes) {
        return ConstructableClassBuilder.builder().addConstructorParameters(constructorParamTypes, constructorParams).addClasses(classes).build();
    }

    public static class ConstructableClassBuilder {
        private final List<Class<?>> constructorClassTypes = new ArrayList();
        private final List<Object> constructorClassValues = new ArrayList<Object>();
        private final List<Class<?>> classes = new ArrayList();

        public static ConstructableClassBuilder builder() {
            return new ConstructableClassBuilder();
        }

        public ConstructableClassBuilder addConstructorParameter(Class<?> type, Object value) {
            this.constructorClassTypes.add(type);
            this.constructorClassValues.add(value);
            return this;
        }

        public ConstructableClassBuilder addConstructorParameters(Collection<Class<?>> types, Collection<Object> values) {
            this.constructorClassTypes.addAll(types);
            this.constructorClassValues.addAll(values);
            return this;
        }

        public ConstructableClassBuilder addClass(Class<?> clazz) {
            this.classes.add(clazz);
            return this;
        }

        public ConstructableClassBuilder addClasses(Class<?> ... clazz) {
            this.classes.addAll(List.of(clazz));
            return this;
        }

        public <E> ConstructableClassBuilder addClasses(Collection<Class<? extends E>> clazz) {
            this.classes.addAll(clazz);
            return this;
        }

        public <T extends RegistryItem> Registry<T> build() {
            Class[] constructorTypes = this.constructorClassTypes.toArray(new Class[0]);
            Object[] constructorValues = this.constructorClassValues.toArray(new Object[0]);
            ArrayList<RegistryItem> tClasses = new ArrayList<RegistryItem>();
            for (Class<?> clazz : this.classes) {
                if (!RegistryItem.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("Class " + clazz.getName() + " does not implement RegistryItem");
                }
                try {
                    tClasses.add((RegistryItem)clazz.getConstructor(constructorTypes).newInstance(constructorValues));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("No constructor found for " + clazz.getName(), e);
                }
            }
            return new Registry(tClasses);
        }
    }
}

